/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.items;

import com.beanbot.instrumentus.common.items.InstrumentusArmorMaterials;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SimpleExplosionDamageCalculator;

public class BreezeArmorItem
extends ArmorItem {
    private static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new SimpleExplosionDamageCalculator(true, false, Optional.of(Float.valueOf(0.7f)), BuiltInRegistries.BLOCK.getTag(BlockTags.BLOCKS_WIND_CHARGE_EXPLOSIONS).map(Function.identity()));

    public BreezeArmorItem(ArmorItem.Type pType) {
        super(InstrumentusArmorMaterials.BREEZE_ARMOR_MATERIAL, pType, new Item.Properties().durability(pType.getDurability(33)));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        MutableComponent press = Component.translatable((String)"instrumentus.tooltip.press_shift").withStyle(ChatFormatting.GRAY);
        MutableComponent empty = Component.literal((String)"");
        MutableComponent pressed1 = Component.translatable((String)"instrumentus.tooltip.wind_boots_1").withStyle(ChatFormatting.GRAY);
        MutableComponent pressed2 = Component.translatable((String)"instrumentus.tooltip.wind_boots_2").withStyle(ChatFormatting.GRAY);
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)press);
            tooltip.add((Component)empty);
            tooltip.add((Component)pressed1);
            tooltip.add((Component)pressed2);
        } else {
            tooltip.add((Component)press);
        }
    }

    public void windJump(ItemStack stack, Player player, Level level) {
        if (!player.onGround()) {
            player.getCooldowns().addCooldown((Item)this, 60);
            player.setIgnoreFallDamageFromCurrentImpulse(true);
            WindCharge windCharge = new WindCharge(player, level, player.position().x(), player.position().y(), player.position().z());
            level.addFreshEntity((Entity)windCharge);
            level.explode((Entity)windCharge, null, EXPLOSION_DAMAGE_CALCULATOR, player.position().x(), player.position().y(), player.position().z(), 1.2f, false, Level.ExplosionInteraction.TRIGGER, (ParticleOptions)ParticleTypes.GUST_EMITTER_SMALL, (ParticleOptions)ParticleTypes.GUST_EMITTER_LARGE, (Holder)SoundEvents.WIND_CHARGE_BURST);
            windCharge.discard();
            stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.FEET);
        }
    }
}

