/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.events;

import com.beanbot.instrumentus.common.blocks.WindBlowerBlock;
import com.beanbot.instrumentus.common.data.attachments.InstrumentusDataAttachments;
import com.beanbot.instrumentus.common.network.data.WindBlowerPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerSpawnPhantomsEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class WindBlowerPhantomPrevention {
    @SubscribeEvent
    public void onWindBlowerPhantomPrevention(PlayerSpawnPhantomsEvent event) {
        Player player = event.getEntity();
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ServerLevel level = (ServerLevel)event.getEntity().level();
        BlockPos blowerBlockPos = (BlockPos)player.getData(InstrumentusDataAttachments.BOUND_WIND_BLOWER);
        BlockPos playerBlockPos = player.getOnPos();
        BlockState blockState = level.getBlockState(blowerBlockPos);
        Block block = blockState.getBlock();
        if (block instanceof WindBlowerBlock) {
            WindBlowerBlock block2 = (WindBlowerBlock)block;
            if ((Integer)blockState.getValue((Property)WindBlowerBlock.BLOWER_CHARGE) > 0 && event.getResult() == PlayerSpawnPhantomsEvent.Result.DEFAULT && (level.dimensionType().hasSkyLight() || playerBlockPos.getY() >= level.getSeaLevel() && level.canSeeSky(playerBlockPos)) && event.getPhantomsToSpawn() > 0) {
                event.setPhantomsToSpawn(0);
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new WindBlowerPayload(blowerBlockPos), (CustomPacketPayload[])new CustomPacketPayload[0]);
                BlockState newState = (BlockState)blockState.setValue((Property)WindBlowerBlock.BLOWER_CHARGE, (Comparable)Integer.valueOf((Integer)blockState.getValue((Property)WindBlowerBlock.BLOWER_CHARGE) - 1));
                level.setBlock(blowerBlockPos, newState, 3);
            }
        }
    }
}

