/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.data.loot.functions;

import com.beanbot.instrumentus.common.config.Config;
import com.beanbot.instrumentus.common.data.loot.functions.InstrumentusLootFunctions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.neoforged.neoforge.common.ModConfigSpec;

public class SetItemCountWithFeatureEnabledFunction
extends LootItemConditionalFunction {
    private final NumberProvider value;
    private final boolean add;
    private final ConfigFeature feature;
    public static final MapCodec<SetItemCountWithFeatureEnabledFunction> CODEC = RecordCodecBuilder.mapCodec(inst -> SetItemCountWithFeatureEnabledFunction.commonFields((RecordCodecBuilder.Instance)inst).and(inst.group((App)NumberProviders.CODEC.fieldOf("count").forGetter(c -> c.value), (App)Codec.BOOL.fieldOf("add").orElse((Object)false).forGetter(a -> a.add), (App)ConfigFeature.CODEC.fieldOf("feature").forGetter(f -> f.getConfigFeature()))).apply((Applicative)inst, SetItemCountWithFeatureEnabledFunction::new));

    public SetItemCountWithFeatureEnabledFunction(List<LootItemCondition> conditions, NumberProvider value, Boolean add, ConfigFeature feature) {
        super(conditions);
        this.value = value;
        this.add = add;
        this.feature = feature;
    }

    public LootItemFunctionType<? extends LootItemConditionalFunction> getType() {
        return InstrumentusLootFunctions.SET_ITEM_COUNT_WITH_FEATURE_ENABLED_FUNCTION.get();
    }

    public ItemStack run(ItemStack stack, LootContext context) {
        int i;
        int n = i = this.add && (Boolean)this.feature.getFeatureValue().get() != false ? stack.getCount() : 0;
        if (((Boolean)this.feature.getFeatureValue().get()).booleanValue()) {
            stack.setCount(i + this.value.getInt(context));
        } else {
            stack.setCount(0);
        }
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> setCountWithFeatureEnabled(NumberProvider countValue, ConfigFeature feature) {
        return SetItemCountWithFeatureEnabledFunction.simpleBuilder(c -> new SetItemCountWithFeatureEnabledFunction((List<LootItemCondition>)c, countValue, false, feature));
    }

    public static LootItemConditionalFunction.Builder<?> setCountWithFeatureEnabled(NumberProvider countValue, boolean add, ConfigFeature feature) {
        return SetItemCountWithFeatureEnabledFunction.simpleBuilder(c -> new SetItemCountWithFeatureEnabledFunction((List<LootItemCondition>)c, countValue, add, feature));
    }

    private ConfigFeature getConfigFeature() {
        return this.feature;
    }

    public static enum ConfigFeature implements StringRepresentable
    {
        HAMMERS(() -> Config.HAMMERS),
        SICKLES(() -> Config.SICKLES),
        PAXELS(() -> Config.PAXELS),
        SHEARS(() -> Config.SHEARS),
        SOULCOPPER(() -> Config.SOULCOPPER),
        ENERGIZED(() -> Config.ENERGIZED),
        KNIVES(() -> Config.KNIVES),
        COPPER_TOOLS(() -> Config.COPPER_TOOLS),
        BRUSHES(() -> Config.BRUSHES),
        EXCAVATORS(() -> Config.EXCAVATORS),
        FIRING(() -> Config.FIRING),
        TRIAL(() -> Config.TRIAL),
        EXPERIMENTAL(() -> Config.EXPERIMENTAL);

        public static final Codec<ConfigFeature> CODEC;
        private Supplier<ModConfigSpec.BooleanValue> feature;

        private ConfigFeature(Supplier feature) {
            this.feature = feature;
        }

        public ModConfigSpec.BooleanValue getFeatureValue() {
            return this.feature.get();
        }

        public String getSerializedName() {
            return this.name();
        }

        static {
            CODEC = StringRepresentable.fromEnum(ConfigFeature::values);
        }
    }
}

