/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.data.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class ToolsInOminousTrialVaultsModifier
extends LootModifier {
    public static final Supplier<MapCodec<ToolsInOminousTrialVaultsModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> ToolsInOminousTrialVaultsModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, ToolsInOminousTrialVaultsModifier::new)));

    public ToolsInOminousTrialVaultsModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, @NotNull LootContext context) {
        generatedLoot.addAll(CustomPools.roll(context));
        return generatedLoot;
    }

    @NotNull
    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }

    private static class CustomPools {
        private static LootPool commonPool = null;
        private static LootPool rarePool = null;
        private static LootPool uniquePool = null;

        private CustomPools() {
        }

        private static List<ItemStack> roll(LootContext context) {
            if (commonPool == null) {
                commonPool = CustomPools.buildLootPool("common");
                rarePool = CustomPools.buildLootPool("rare");
                uniquePool = CustomPools.buildLootPool("unique");
            }
            ArrayList<ItemStack> res = new ArrayList<ItemStack>();
            commonPool.addRandomItems(res::add, context);
            rarePool.addRandomItems(res::add, context);
            uniquePool.addRandomItems(res::add, context);
            return res;
        }

        private static LootPool buildLootPool(String name) {
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"instrumentus", (String)("custom/" + name + "_ominous_vault_loot")));
            return LootPool.lootPool().add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)key).setWeight(1)).name("instrumentus_custom_" + name).build();
        }
    }
}

