/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.data.generator;

import com.beanbot.instrumentus.common.blocks.InstrumentusBlocks;
import com.beanbot.instrumentus.common.data.loot.functions.SetItemCountWithFeatureEnabledFunction;
import com.beanbot.instrumentus.common.items.InstrumentusItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public class InstrumentusGeneratorLootTables
extends LootTableProvider {
    public InstrumentusGeneratorLootTables(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(GeneratorBlockLootTables::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(CustomVaultLootProvider::new, LootContextParamSets.CHEST), new LootTableProvider.SubProviderEntry(CustomOminousVaultLootProvider::new, LootContextParamSets.CHEST)), lookupProvider);
    }

    private static ResourceKey<LootTable> lootResourceKey(String id) {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"instrumentus", (String)id));
    }

    private record CustomOminousVaultLootProvider(HolderLookup.Provider provider) implements LootTableSubProvider
    {
        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> builder) {
            LootPool.Builder commonPool = LootPool.lootPool();
            commonPool.setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).add(this.createEntry((ItemLike)InstrumentusItems.ENERGIZED_INGOT.get(), 4, 2, 6, SetItemCountWithFeatureEnabledFunction.ConfigFeature.ENERGIZED)).add(this.createEntry((ItemLike)InstrumentusItems.SOULCOPPER_BLOCK.get(), 3, 1, 2, SetItemCountWithFeatureEnabledFunction.ConfigFeature.SOULCOPPER));
            LootTable.Builder commonTable = LootTable.lootTable();
            commonTable.withPool(commonPool);
            builder.accept(InstrumentusGeneratorLootTables.lootResourceKey("custom/common_ominous_vault_loot"), commonTable);
            LootPool.Builder rarePool = LootPool.lootPool();
            rarePool.setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).add(this.createEntry((ItemLike)InstrumentusItems.ENERGIZED_PAXEL.get(), 2, 1, 1, SetItemCountWithFeatureEnabledFunction.ConfigFeature.ENERGIZED)).add(this.createEntry((ItemLike)InstrumentusItems.NETHERITE_SICKLE.get(), 3, 1, 1, SetItemCountWithFeatureEnabledFunction.ConfigFeature.SICKLES)).add(this.enchantedTool((ItemLike)InstrumentusItems.ENERGIZED_PICKAXE.get(), 1, SetItemCountWithFeatureEnabledFunction.ConfigFeature.ENERGIZED));
            LootTable.Builder rareTable = LootTable.lootTable();
            rareTable.withPool(rarePool);
            builder.accept(InstrumentusGeneratorLootTables.lootResourceKey("custom/rare_ominous_vault_loot"), rareTable);
            LootPool.Builder uniquePool = LootPool.lootPool();
            uniquePool.setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).add(this.enchantedTool((ItemLike)InstrumentusItems.ENERGIZED_PAXEL.get(), 1, SetItemCountWithFeatureEnabledFunction.ConfigFeature.ENERGIZED)).add(this.createEntry((ItemLike)InstrumentusItems.ENERGIZED_BLOCK.get(), 3, 1, 2, SetItemCountWithFeatureEnabledFunction.ConfigFeature.ENERGIZED)).add(this.createEntry((ItemLike)InstrumentusItems.SOULCOPPER_BLOCK.get(), 4, 1, 2, SetItemCountWithFeatureEnabledFunction.ConfigFeature.SOULCOPPER)).add(this.enchantedTool((ItemLike)InstrumentusItems.NETHERITE_PAXEL.get(), 2, SetItemCountWithFeatureEnabledFunction.ConfigFeature.PAXELS));
            LootTable.Builder uniqueTable = LootTable.lootTable();
            uniqueTable.withPool(uniquePool);
            builder.accept(InstrumentusGeneratorLootTables.lootResourceKey("custom/unique_ominous_vault_loot"), uniqueTable);
        }

        private LootPoolEntryContainer.Builder<?> enchantedTool(ItemLike item, int weight) {
            return this.createEntry(new ItemStack(item), weight).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))).apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment((HolderLookup.Provider)this.provider));
        }

        private LootPoolEntryContainer.Builder<?> enchantedTool(ItemLike item, int weight, SetItemCountWithFeatureEnabledFunction.ConfigFeature feature) {
            return this.createEntry(new ItemStack(item), weight).apply(SetItemCountWithFeatureEnabledFunction.setCountWithFeatureEnabled((NumberProvider)ConstantValue.exactly((float)1.0f), feature)).apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment((HolderLookup.Provider)this.provider));
        }

        private LootPoolEntryContainer.Builder<?> createEntry(ItemLike item, int weight, int min, int max) {
            return this.createEntry(new ItemStack(item), 1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)min, (float)max)));
        }

        private LootPoolSingletonContainer.Builder<?> createEntry(ItemStack item, int weight) {
            return LootItem.lootTableItem((ItemLike)item.getItem()).setWeight(weight);
        }

        private LootPoolEntryContainer.Builder<?> createEntry(ItemLike item, int weight, int min, int max, SetItemCountWithFeatureEnabledFunction.ConfigFeature feature) {
            return this.createEntry(new ItemStack(item), weight).apply(SetItemCountWithFeatureEnabledFunction.setCountWithFeatureEnabled((NumberProvider)UniformGenerator.between((float)min, (float)max), feature));
        }
    }

    private record CustomVaultLootProvider(HolderLookup.Provider provider) implements LootTableSubProvider
    {
        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> builder) {
            LootPool.Builder commonPool = LootPool.lootPool();
            commonPool.setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).add(this.createEntry((ItemLike)InstrumentusItems.COPPER_SWORD.get(), 2, 1, 1, SetItemCountWithFeatureEnabledFunction.ConfigFeature.COPPER_TOOLS)).add(this.createEntry((ItemLike)InstrumentusItems.COPPER_PAXEL.get(), 2, 1, 1, SetItemCountWithFeatureEnabledFunction.ConfigFeature.COPPER_TOOLS)).add(this.createEntry((ItemLike)InstrumentusItems.RAW_SOULCOPPER.get(), 4, 4, 8, SetItemCountWithFeatureEnabledFunction.ConfigFeature.SOULCOPPER));
            LootTable.Builder commonTable = LootTable.lootTable();
            commonTable.withPool(commonPool);
            builder.accept(InstrumentusGeneratorLootTables.lootResourceKey("custom/common_vault_loot"), commonTable);
            LootPool.Builder rarePool = LootPool.lootPool();
            rarePool.setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).add(this.enchantedTool((ItemLike)InstrumentusItems.IRON_PAXEL.get(), 1, SetItemCountWithFeatureEnabledFunction.ConfigFeature.PAXELS)).add(this.enchantedTool((ItemLike)InstrumentusItems.IRON_HAMMER.get(), 1, SetItemCountWithFeatureEnabledFunction.ConfigFeature.HAMMERS)).add(this.createEntry((ItemLike)InstrumentusItems.RAW_SOULCOPPER_BLOCK.get(), 2, 1, 3, SetItemCountWithFeatureEnabledFunction.ConfigFeature.SOULCOPPER)).add(this.createEntry((ItemLike)InstrumentusItems.SOULCOPPER_INGOT.get(), 3, 4, 6, SetItemCountWithFeatureEnabledFunction.ConfigFeature.SOULCOPPER));
            LootTable.Builder rareTable = LootTable.lootTable();
            rareTable.withPool(rarePool);
            builder.accept(InstrumentusGeneratorLootTables.lootResourceKey("custom/rare_vault_loot"), rareTable);
            LootPool.Builder uniquePool = LootPool.lootPool();
            uniquePool.setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).add(this.enchantedTool((ItemLike)InstrumentusItems.DIAMOND_PAXEL.get(), 1, SetItemCountWithFeatureEnabledFunction.ConfigFeature.PAXELS)).add(this.enchantedTool((ItemLike)InstrumentusItems.DIAMOND_HAMMER.get(), 1, SetItemCountWithFeatureEnabledFunction.ConfigFeature.HAMMERS)).add(this.createEntry((ItemLike)InstrumentusItems.SOULCOPPER_BURNER.get(), 3, 1, 1, SetItemCountWithFeatureEnabledFunction.ConfigFeature.SOULCOPPER)).add(this.createEntry((ItemLike)InstrumentusItems.ENERGIZED_INGOT.get(), 2, 2, 3, SetItemCountWithFeatureEnabledFunction.ConfigFeature.ENERGIZED));
            LootTable.Builder uniqueTable = LootTable.lootTable();
            uniqueTable.withPool(uniquePool);
            builder.accept(InstrumentusGeneratorLootTables.lootResourceKey("custom/unique_vault_loot"), uniqueTable);
        }

        private LootPoolEntryContainer.Builder<?> enchantedTool(ItemLike item, int weight) {
            return this.createEntry(new ItemStack(item), weight).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))).apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment((HolderLookup.Provider)this.provider));
        }

        private LootPoolEntryContainer.Builder<?> enchantedTool(ItemLike item, int weight, SetItemCountWithFeatureEnabledFunction.ConfigFeature feature) {
            return this.createEntry(new ItemStack(item), weight).apply(SetItemCountWithFeatureEnabledFunction.setCountWithFeatureEnabled((NumberProvider)ConstantValue.exactly((float)1.0f), feature)).apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment((HolderLookup.Provider)this.provider));
        }

        private LootPoolEntryContainer.Builder<?> createEntry(ItemLike item, int weight, int min, int max) {
            return this.createEntry(new ItemStack(item), 1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)min, (float)max)));
        }

        private LootPoolSingletonContainer.Builder<?> createEntry(ItemStack item, int weight) {
            return LootItem.lootTableItem((ItemLike)item.getItem()).setWeight(weight);
        }

        private LootPoolEntryContainer.Builder<?> createEntry(ItemLike item, int weight, int min, int max, SetItemCountWithFeatureEnabledFunction.ConfigFeature feature) {
            return this.createEntry(new ItemStack(item), weight).apply(SetItemCountWithFeatureEnabledFunction.setCountWithFeatureEnabled((NumberProvider)UniformGenerator.between((float)min, (float)max), feature));
        }

        private LootPoolEntryContainer.Builder<?> createEntry(ItemLike item, int weight, SetItemCountWithFeatureEnabledFunction.ConfigFeature feature) {
            return this.createEntry(new ItemStack(item), weight).apply(SetItemCountWithFeatureEnabledFunction.setCountWithFeatureEnabled((NumberProvider)ConstantValue.exactly((float)1.0f), feature));
        }
    }

    private static class GeneratorBlockLootTables
    extends BlockLootSubProvider {
        public GeneratorBlockLootTables(HolderLookup.Provider provider) {
            super(Set.of(), FeatureFlags.DEFAULT_FLAGS, provider);
        }

        protected void generate() {
            this.add((Block)InstrumentusBlocks.COPPER_SOUL_FLAME_LIGHT.get(), GeneratorBlockLootTables.noDrop());
            this.dropSelf((Block)InstrumentusBlocks.SOULCOPPER_LANTERN.get());
            this.dropSelf((Block)InstrumentusBlocks.SOULCOPPER_TORCH.get());
            this.dropSelf((Block)InstrumentusBlocks.ENERGIZED_BLOCK.get());
            this.dropSelf((Block)InstrumentusBlocks.RAW_SOULCOPPER_BLOCK.get());
            this.dropSelf((Block)InstrumentusBlocks.SOULCOPPER_BLOCK.get());
            this.dropSelf((Block)InstrumentusBlocks.KILN.get());
            this.dropSelf((Block)InstrumentusBlocks.CUT_SOULCOPPER.get());
            this.dropSelf((Block)InstrumentusBlocks.SOULCOPPER_GRATE.get());
            this.dropSelf((Block)InstrumentusBlocks.SOULCOPPER_TRAPDOOR.get());
            this.add((Block)InstrumentusBlocks.SOULCOPPER_DOOR.get(), this.createDoorTable((Block)InstrumentusBlocks.SOULCOPPER_DOOR.get()));
            this.dropSelf((Block)InstrumentusBlocks.WIND_BLOWER.get());
            this.dropSelf((Block)InstrumentusBlocks.CUT_SOULCOPPER_STAIRS.get());
            this.dropSelf((Block)InstrumentusBlocks.CUT_SOULCOPPER_SLAB.get());
            this.dropSelf((Block)InstrumentusBlocks.CHISELED_SOULCOPPER.get());
            this.dropSelf((Block)InstrumentusBlocks.SOULCOPPER_BULB.get());
            this.add((Block)InstrumentusBlocks.COPPER_SOUL_CAMPFIRE.get(), silkTouchDispatchTable -> this.createSilkTouchDispatchTable((Block)silkTouchDispatchTable, (LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)silkTouchDispatchTable, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.RAW_COPPER).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)6.0f))))));
        }

        @NotNull
        protected Iterable<Block> getKnownBlocks() {
            ArrayList<Block> knownBlocks = new ArrayList<Block>();
            knownBlocks.addAll(InstrumentusBlocks.BLOCKS_REGISTER.getEntries().stream().map(DeferredHolder::get).toList());
            return knownBlocks;
        }
    }
}

