/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.data.generator;

import com.beanbot.instrumentus.common.items.ExcavatorItem;
import com.beanbot.instrumentus.common.items.HammerItem;
import com.beanbot.instrumentus.common.items.InstrumentusBrushItem;
import com.beanbot.instrumentus.common.items.InstrumentusItems;
import com.beanbot.instrumentus.common.items.InstrumentusShearsItem;
import com.beanbot.instrumentus.common.items.KnifeItem;
import com.beanbot.instrumentus.common.items.PaxelItem;
import com.beanbot.instrumentus.common.items.SickleItem;
import com.beanbot.instrumentus.common.items.SoulcopperPickaxeItem;
import com.beanbot.instrumentus.common.items.interfaces.IEnergyItem;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public class InstrumentusGeneratorItemTags
extends ItemTagsProvider {
    public static final TagKey<Item> TOOLS_COMMON_KNIVES = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"tools/knives"));
    public static final TagKey<Item> TOOLS_KNIVES = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"knives"));
    public static final TagKey<Item> TOOLS_SHEARS = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"tools/shears"));
    public static final TagKey<Item> TOOLS_SICKLES = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"tools/sickles"));
    public static final TagKey<Item> TOOLS_HAMMERS = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"tools/hammers"));
    public static final TagKey<Item> TOOLS_BRUSHES = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"tools/brushes"));
    public static final TagKey<Item> TOOLS_MINING_TOOLS = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"tools/mining_tools"));

    public InstrumentusGeneratorItemTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, BlockTagsProvider blockTags, @Nullable ExistingFileHelper helper) {
        super(output, lookupProvider, blockTags.contentsGetter(), "instrumentus", helper);
    }

    protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.addToolEnchantments();
        for (DeferredHolder item : InstrumentusItems.ITEMS_REGISTRAR.getEntries()) {
            Object object = item.get();
            if (object instanceof KnifeItem) {
                KnifeItem knife = (KnifeItem)((Object)object);
                this.tag(TOOLS_COMMON_KNIVES).add((Object)knife);
                this.tag(TOOLS_KNIVES).add((Object)knife);
                continue;
            }
            object = item.get();
            if (object instanceof InstrumentusShearsItem) {
                InstrumentusShearsItem shears = (InstrumentusShearsItem)((Object)object);
                this.tag(TOOLS_SHEARS).add((Object)shears);
                continue;
            }
            object = item.get();
            if (object instanceof SickleItem) {
                SickleItem sickle = (SickleItem)((Object)object);
                this.tag(TOOLS_SICKLES).add((Object)sickle);
                continue;
            }
            object = item.get();
            if (object instanceof HammerItem) {
                HammerItem hammer = (HammerItem)((Object)object);
                this.tag(TOOLS_HAMMERS).add((Object)hammer);
                this.tag(TOOLS_MINING_TOOLS).add((Object)hammer);
                continue;
            }
            object = item.get();
            if (object instanceof InstrumentusBrushItem) {
                InstrumentusBrushItem brush = (InstrumentusBrushItem)((Object)object);
                this.tag(TOOLS_BRUSHES).add((Object)brush);
                continue;
            }
            object = item.get();
            if (object instanceof PickaxeItem) {
                PickaxeItem pickaxeItem = (PickaxeItem)object;
                this.tag(TOOLS_MINING_TOOLS).add((Object)pickaxeItem);
                continue;
            }
            object = item.get();
            if (!(object instanceof SoulcopperPickaxeItem)) continue;
            SoulcopperPickaxeItem pickaxeItem = (SoulcopperPickaxeItem)((Object)object);
            this.tag(TOOLS_MINING_TOOLS).add((Object)pickaxeItem);
        }
    }

    public void addToolEnchantments() {
        this.tag(ItemTags.MINING_LOOT_ENCHANTABLE).add((Object)((Item)InstrumentusItems.SOULCOPPER_PICKAXE.get()));
        this.tag(ItemTags.MINING_ENCHANTABLE).add((Object)((Item)InstrumentusItems.SOULCOPPER_PICKAXE.get()));
        this.tag(ItemTags.DURABILITY_ENCHANTABLE).add((Object)((Item)InstrumentusItems.SOULCOPPER_PICKAXE.get()));
        this.tag(ItemTags.FOOT_ARMOR_ENCHANTABLE).add((Object)((Item)InstrumentusItems.BREEZE_ARMOR_BOOTS.get()));
        this.tag(ItemTags.DURABILITY_ENCHANTABLE).add((Object)((Item)InstrumentusItems.BREEZE_ARMOR_BOOTS.get()));
        for (DeferredHolder tool : InstrumentusItems.ITEMS_REGISTRAR.getEntries()) {
            Object object = tool.get();
            if (object instanceof DiggerItem) {
                DiggerItem diggerTool = (DiggerItem)object;
                if (diggerTool instanceof ExcavatorItem || diggerTool instanceof ShovelItem) {
                    this.tag(ItemTags.MINING_ENCHANTABLE).add((Object)diggerTool);
                    this.tag(ItemTags.DURABILITY_ENCHANTABLE).add((Object)diggerTool);
                    continue;
                }
                if (diggerTool instanceof IEnergyItem) {
                    this.tag(ItemTags.DURABILITY_ENCHANTABLE).add((Object)diggerTool);
                    this.tag(ItemTags.MINING_ENCHANTABLE).add((Object)diggerTool);
                    if (diggerTool != InstrumentusItems.ENERGIZED_SHOVEL.get()) {
                        this.tag(ItemTags.MINING_LOOT_ENCHANTABLE).add((Object)diggerTool);
                    }
                    if (diggerTool != InstrumentusItems.ENERGIZED_AXE.get() && diggerTool != InstrumentusItems.ENERGIZED_PAXEL.get()) continue;
                    this.tag(ItemTags.SHARP_WEAPON_ENCHANTABLE).add((Object)diggerTool);
                    continue;
                }
                if (diggerTool instanceof PaxelItem || diggerTool == InstrumentusItems.COPPER_AXE.get()) {
                    this.tag(ItemTags.SHARP_WEAPON_ENCHANTABLE).add((Object)diggerTool);
                    this.tag(ItemTags.MINING_ENCHANTABLE).add((Object)diggerTool);
                    this.tag(ItemTags.MINING_LOOT_ENCHANTABLE).add((Object)diggerTool);
                    this.tag(ItemTags.DURABILITY_ENCHANTABLE).add((Object)diggerTool);
                    continue;
                }
                this.tag(ItemTags.MINING_ENCHANTABLE).add((Object)diggerTool);
                this.tag(ItemTags.MINING_LOOT_ENCHANTABLE).add((Object)diggerTool);
                this.tag(ItemTags.DURABILITY_ENCHANTABLE).add((Object)diggerTool);
                continue;
            }
            object = tool.get();
            if (object instanceof ShearsItem) {
                ShearsItem shearsTool = (ShearsItem)object;
                this.tag(ItemTags.MINING_ENCHANTABLE).add((Object)shearsTool);
                this.tag(ItemTags.DURABILITY_ENCHANTABLE).add((Object)shearsTool);
                continue;
            }
            object = tool.get();
            if (object instanceof KnifeItem) {
                KnifeItem knifeTool = (KnifeItem)((Object)object);
                this.tag(ItemTags.DURABILITY_ENCHANTABLE).add((Object)knifeTool);
                continue;
            }
            object = tool.get();
            if (!(object instanceof SwordItem)) continue;
            SwordItem swordTool = (SwordItem)object;
            this.tag(ItemTags.DURABILITY_ENCHANTABLE).add((Object)swordTool);
            this.tag(ItemTags.SWORD_ENCHANTABLE).add((Object)swordTool);
        }
    }
}

