/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.data.generator;

import com.beanbot.instrumentus.common.data.generator.InstrumentusGeneratorItemTags;
import com.beanbot.instrumentus.common.data.loot.PlantFiberFromGrassModifier;
import com.beanbot.instrumentus.common.data.loot.ToolsInOminousTrialVaultsModifier;
import com.beanbot.instrumentus.common.data.loot.ToolsInTrialVaultsModifier;
import com.beanbot.instrumentus.common.items.InstrumentusItems;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.GlobalLootModifierProvider;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootTableIdCondition;

public class InstrumentusGeneratorGlobalLootModifier
extends GlobalLootModifierProvider {
    public InstrumentusGeneratorGlobalLootModifier(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(output, lookupProvider, "instrumentus");
    }

    protected void start() {
        this.add("plant_fiber_from_grass", (IGlobalLootModifier)new PlantFiberFromGrassModifier(new LootItemCondition[]{AnyOfCondition.anyOf((LootItemCondition.Builder[])new LootItemCondition.Builder[]{MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(InstrumentusGeneratorItemTags.TOOLS_KNIVES))}).build(), LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)Blocks.SHORT_GRASS).build()}, (Item)InstrumentusItems.PLANT_FIBER.get()), new ICondition[0]);
        this.add("plant_fiber_from_tall_grass", (IGlobalLootModifier)new PlantFiberFromGrassModifier(new LootItemCondition[]{AnyOfCondition.anyOf((LootItemCondition.Builder[])new LootItemCondition.Builder[]{MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(InstrumentusGeneratorItemTags.TOOLS_KNIVES))}).build(), LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)Blocks.TALL_GRASS).build()}, (Item)InstrumentusItems.PLANT_FIBER.get()), new ICondition[0]);
        this.add("vault_loot", (IGlobalLootModifier)new ToolsInTrialVaultsModifier(new LootItemCondition[]{this.getVault("reward")}), new ICondition[0]);
        this.add("ominous_vault_loot", (IGlobalLootModifier)new ToolsInOminousTrialVaultsModifier(new LootItemCondition[]{this.getVault("reward_ominous")}), new ICondition[0]);
    }

    private LootItemCondition getVault(String vault) {
        LootTableIdCondition.Builder condition = LootTableIdCondition.builder((ResourceLocation)ResourceLocation.parse((String)("chests/trial_chambers/" + vault)));
        return condition.build();
    }
}

