/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.data.generator;

import com.beanbot.instrumentus.common.blocks.InstrumentusBlocks;
import com.beanbot.instrumentus.common.blocks.KilnBlock;
import com.beanbot.instrumentus.common.blocks.WindBlowerBlock;
import java.util.Objects;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class InstrumentusGeneratorBlockStates
extends BlockStateProvider {
    public InstrumentusGeneratorBlockStates(PackOutput output, ExistingFileHelper helper) {
        super(output, "instrumentus", helper);
    }

    protected void registerStatesAndModels() {
        this.simpleBlock((Block)InstrumentusBlocks.SOULCOPPER_BLOCK.get(), (ModelFile)this.models().cubeAll(InstrumentusBlocks.SOULCOPPER_BLOCK.getId().getPath(), this.blockTexture((Block)InstrumentusBlocks.SOULCOPPER_BLOCK.get())));
        this.simpleBlock((Block)InstrumentusBlocks.RAW_SOULCOPPER_BLOCK.get(), (ModelFile)this.models().cubeAll(InstrumentusBlocks.RAW_SOULCOPPER_BLOCK.getId().getPath(), this.blockTexture((Block)InstrumentusBlocks.RAW_SOULCOPPER_BLOCK.get())));
        this.simpleBlock((Block)InstrumentusBlocks.ENERGIZED_BLOCK.get(), (ModelFile)this.models().cubeAll(InstrumentusBlocks.ENERGIZED_BLOCK.getId().getPath(), this.blockTexture((Block)InstrumentusBlocks.ENERGIZED_BLOCK.get())));
        this.simpleBlock((Block)InstrumentusBlocks.COPPER_SOUL_FLAME_LIGHT.get(), (ModelFile)((BlockModelBuilder)this.models().cubeAll(InstrumentusBlocks.COPPER_SOUL_FLAME_LIGHT.getId().getPath(), this.blockTexture((Block)InstrumentusBlocks.COPPER_SOUL_FLAME_LIGHT.get()))).renderType(RenderType.CUTOUT.name));
        this.simpleBlock((Block)InstrumentusBlocks.SOULCOPPER_TORCH.get(), (ModelFile)((BlockModelBuilder)this.models().torch(InstrumentusBlocks.SOULCOPPER_TORCH.getId().getPath(), this.modLoc("block/copper_soul_torch"))).renderType(RenderType.CUTOUT.name));
        this.horizontalBlock((Block)InstrumentusBlocks.SOULCOPPER_WALL_TORCH.get(), (ModelFile)((BlockModelBuilder)this.models().torchWall(InstrumentusBlocks.SOULCOPPER_WALL_TORCH.getId().getPath(), this.modLoc("block/copper_soul_torch"))).renderType(RenderType.CUTOUT.name), 90);
        this.simpleBlock((Block)InstrumentusBlocks.CUT_SOULCOPPER.get(), (ModelFile)this.models().cubeAll(InstrumentusBlocks.CUT_SOULCOPPER.getId().getPath(), this.blockTexture((Block)InstrumentusBlocks.CUT_SOULCOPPER.get())));
        this.simpleBlock((Block)InstrumentusBlocks.SOULCOPPER_GRATE.get(), (ModelFile)((BlockModelBuilder)this.models().cubeAll(InstrumentusBlocks.SOULCOPPER_GRATE.getId().getPath(), this.blockTexture((Block)InstrumentusBlocks.SOULCOPPER_GRATE.get()))).renderType(RenderType.CUTOUT.name));
        this.doorBlockWithRenderType((DoorBlock)InstrumentusBlocks.SOULCOPPER_DOOR.get(), Objects.requireNonNull(InstrumentusBlocks.SOULCOPPER_DOOR.getId()).getPath(), this.modLoc("block/soulcopper_door_bottom"), this.modLoc("block/soulcopper_door_top"), RenderType.CUTOUT.name);
        this.trapdoorBlockWithRenderType((TrapDoorBlock)InstrumentusBlocks.SOULCOPPER_TRAPDOOR.get(), this.modLoc("block/soulcopper_trapdoor"), true, RenderType.CUTOUT.name);
        this.stairsBlock((StairBlock)InstrumentusBlocks.CUT_SOULCOPPER_STAIRS.get(), InstrumentusBlocks.CUT_SOULCOPPER_STAIRS.getId().getPath(), this.modLoc("block/cut_soulcopper"));
        this.slabBlock((SlabBlock)InstrumentusBlocks.CUT_SOULCOPPER_SLAB.get(), this.modLoc("block/cut_soulcopper"), this.modLoc("block/cut_soulcopper"));
        this.simpleBlock((Block)InstrumentusBlocks.CHISELED_SOULCOPPER.get(), (ModelFile)this.models().cubeAll(InstrumentusBlocks.CHISELED_SOULCOPPER.getId().getPath(), this.blockTexture((Block)InstrumentusBlocks.CHISELED_SOULCOPPER.get())));
        this.simpleBlock((Block)InstrumentusBlocks.SOULCOPPER_BULB.get(), (ModelFile)this.models().cubeAll(InstrumentusBlocks.SOULCOPPER_BULB.getId().getPath(), this.blockTexture((Block)InstrumentusBlocks.SOULCOPPER_BULB.get())));
        this.getVariantBuilder((Block)InstrumentusBlocks.WIND_BLOWER.get()).forAllStates(s -> {
            int charge = (Integer)s.getValue((Property)WindBlowerBlock.BLOWER_CHARGE);
            ModelBuilder model = charge == 0 ? ((BlockModelBuilder)this.models().cubeBottomTop(Objects.requireNonNull(InstrumentusBlocks.WIND_BLOWER.getId()).getPath(), this.modLoc("block/" + InstrumentusBlocks.WIND_BLOWER.getId().getPath() + "_side0"), this.modLoc("block/" + InstrumentusBlocks.WIND_BLOWER.getId().getPath() + "_bottom"), this.modLoc("block/" + InstrumentusBlocks.WIND_BLOWER.getId().getPath() + "_top"))).renderType("solid") : (charge == 1 ? ((BlockModelBuilder)this.models().cubeBottomTop(Objects.requireNonNull(InstrumentusBlocks.WIND_BLOWER.getId()).getPath() + "_1", this.modLoc("block/" + InstrumentusBlocks.WIND_BLOWER.getId().getPath() + "_side1"), this.modLoc("block/" + InstrumentusBlocks.WIND_BLOWER.getId().getPath() + "_bottom"), this.modLoc("block/" + InstrumentusBlocks.WIND_BLOWER.getId().getPath() + "_top"))).renderType("solid") : (charge == 2 ? ((BlockModelBuilder)this.models().cubeBottomTop(Objects.requireNonNull(InstrumentusBlocks.WIND_BLOWER.getId()).getPath() + "_2", this.modLoc("block/" + InstrumentusBlocks.WIND_BLOWER.getId().getPath() + "_side2"), this.modLoc("block/" + InstrumentusBlocks.WIND_BLOWER.getId().getPath() + "_bottom"), this.modLoc("block/" + InstrumentusBlocks.WIND_BLOWER.getId().getPath() + "_top"))).renderType("solid") : (charge == 3 ? ((BlockModelBuilder)this.models().cubeBottomTop(Objects.requireNonNull(InstrumentusBlocks.WIND_BLOWER.getId()).getPath() + "_3", this.modLoc("block/" + InstrumentusBlocks.WIND_BLOWER.getId().getPath() + "_side3"), this.modLoc("block/" + InstrumentusBlocks.WIND_BLOWER.getId().getPath() + "_bottom"), this.modLoc("block/" + InstrumentusBlocks.WIND_BLOWER.getId().getPath() + "_top"))).renderType("solid") : ((BlockModelBuilder)this.models().cubeBottomTop(Objects.requireNonNull(InstrumentusBlocks.WIND_BLOWER.getId()).getPath() + "_4", this.modLoc("block/" + InstrumentusBlocks.WIND_BLOWER.getId().getPath() + "_side4"), this.modLoc("block/" + InstrumentusBlocks.WIND_BLOWER.getId().getPath() + "_bottom"), this.modLoc("block/" + InstrumentusBlocks.WIND_BLOWER.getId().getPath() + "_top"))).renderType("solid"))));
            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
        });
        this.getVariantBuilder((Block)InstrumentusBlocks.KILN.get()).forAllStates(s -> {
            boolean active = (Boolean)s.getValue((Property)KilnBlock.LIT);
            Direction dir = (Direction)s.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            ModelBuilder model = active ? ((BlockModelBuilder)this.models().orientableWithBottom(Objects.requireNonNull(InstrumentusBlocks.KILN.getId()).getPath() + "_on", this.modLoc("block/" + InstrumentusBlocks.KILN.getId().getPath() + "_side"), this.modLoc("block/" + InstrumentusBlocks.KILN.getId().getPath() + "_front_on"), this.modLoc("block/" + InstrumentusBlocks.KILN.getId().getPath() + "_bottom"), this.modLoc("block/" + InstrumentusBlocks.KILN.getId().getPath() + "_top"))).renderType("solid") : ((BlockModelBuilder)this.models().orientableWithBottom(Objects.requireNonNull(InstrumentusBlocks.KILN.getId()).getPath(), this.modLoc("block/" + InstrumentusBlocks.KILN.getId().getPath() + "_side"), this.modLoc("block/" + InstrumentusBlocks.KILN.getId().getPath() + "_front"), this.modLoc("block/" + InstrumentusBlocks.KILN.getId().getPath() + "_bottom"), this.modLoc("block/" + InstrumentusBlocks.KILN.getId().getPath() + "_top"))).renderType("solid");
            return ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(((int)dir.toYRot() + 180) % 360).build();
        });
        this.getVariantBuilder((Block)InstrumentusBlocks.COPPER_SOUL_CAMPFIRE.get()).forAllStates(s -> {
            boolean lit = (Boolean)s.getValue((Property)BlockStateProperties.LIT);
            Object model = lit ? ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(InstrumentusBlocks.COPPER_SOUL_CAMPFIRE.getId().getPath(), ResourceLocation.parse((String)"minecraft:block/template_campfire"))).texture("fire", this.modLoc("block/copper_soul_campfire_fire"))).texture("lit_log", this.modLoc("block/copper_soul_campfire_log_lit"))).renderType(RenderType.CUTOUT.name) : this.models().getExistingFile(this.mcLoc("block/campfire_off"));
            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
        });
        this.getVariantBuilder((Block)InstrumentusBlocks.SOULCOPPER_LANTERN.get()).forAllStates(s -> {
            boolean hanging = (Boolean)s.getValue((Property)BlockStateProperties.HANGING);
            ModelBuilder model = hanging ? ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(InstrumentusBlocks.SOULCOPPER_LANTERN.getId().getPath() + "_hanging", ResourceLocation.parse((String)"minecraft:block/template_hanging_lantern"))).texture("lantern", this.modLoc("block/copper_soul_lantern"))).renderType(RenderType.CUTOUT.name) : ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(InstrumentusBlocks.SOULCOPPER_LANTERN.getId().getPath(), ResourceLocation.parse((String)"minecraft:block/template_lantern"))).texture("lantern", this.modLoc("block/copper_soul_lantern"))).renderType(RenderType.CUTOUT.name);
            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
        });
    }
}

