/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.data.generator;

import com.beanbot.instrumentus.common.data.generator.InstrumentusGeneratorBlockStates;
import com.beanbot.instrumentus.common.data.generator.InstrumentusGeneratorBlockTags;
import com.beanbot.instrumentus.common.data.generator.InstrumentusGeneratorGlobalLootModifier;
import com.beanbot.instrumentus.common.data.generator.InstrumentusGeneratorItemModels;
import com.beanbot.instrumentus.common.data.generator.InstrumentusGeneratorItemTags;
import com.beanbot.instrumentus.common.data.generator.InstrumentusGeneratorLanguage;
import com.beanbot.instrumentus.common.data.generator.InstrumentusGeneratorLootTables;
import com.beanbot.instrumentus.common.data.generator.InstrumentusGeneratorRecipes;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="instrumentus", bus=EventBusSubscriber.Bus.MOD)
public class InstrumentusGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new InstrumentusGeneratorRecipes(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new InstrumentusGeneratorLootTables(output, event.getLookupProvider()));
        InstrumentusGeneratorBlockTags blockTags = new InstrumentusGeneratorBlockTags(output, lookupProvider, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        InstrumentusGeneratorItemTags itemTags = new InstrumentusGeneratorItemTags(output, lookupProvider, blockTags, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)itemTags);
        generator.addProvider(event.includeClient(), (DataProvider)new InstrumentusGeneratorBlockStates(output, event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new InstrumentusGeneratorItemModels(output, event.getExistingFileHelper()));
        generator.addProvider(event.includeServer(), (DataProvider)new InstrumentusGeneratorGlobalLootModifier(output, event.getLookupProvider()));
        generator.addProvider(event.includeClient(), (DataProvider)new InstrumentusGeneratorLanguage(output));
    }
}

