/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.data.conditions;

import com.beanbot.instrumentus.common.config.Config;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.conditions.ICondition;

public record FeatureEnabledCondition(ConfigFeature feature) implements ICondition
{
    public static final MapCodec<FeatureEnabledCondition> CODEC = ConfigFeature.CODEC.fieldOf("feature").xmap(configFeature -> new FeatureEnabledCondition((ConfigFeature)((Object)configFeature)), condition -> condition.getConfigFeature());

    private ConfigFeature getConfigFeature() {
        return this.feature;
    }

    public boolean test(ICondition.IContext context) {
        return (Boolean)this.feature.getFeatureValue().get();
    }

    public MapCodec<? extends ICondition> codec() {
        return CODEC;
    }

    public static enum ConfigFeature implements StringRepresentable
    {
        HAMMERS(() -> Config.HAMMERS),
        SICKLES(() -> Config.SICKLES),
        PAXELS(() -> Config.PAXELS),
        SHEARS(() -> Config.SHEARS),
        SOULCOPPER(() -> Config.SOULCOPPER),
        ENERGIZED(() -> Config.ENERGIZED),
        KNIVES(() -> Config.KNIVES),
        COPPER_TOOLS(() -> Config.COPPER_TOOLS),
        BRUSHES(() -> Config.BRUSHES),
        EXCAVATORS(() -> Config.EXCAVATORS),
        FIRING(() -> Config.FIRING),
        TRIAL(() -> Config.TRIAL),
        EXPERIMENTAL(() -> Config.EXPERIMENTAL);

        public static final Codec<ConfigFeature> CODEC;
        private Supplier<ModConfigSpec.BooleanValue> feature;

        private ConfigFeature(Supplier feature) {
            this.feature = feature;
        }

        public ModConfigSpec.BooleanValue getFeatureValue() {
            return this.feature.get();
        }

        public String getSerializedName() {
            return this.name();
        }

        static {
            CODEC = StringRepresentable.fromEnum(ConfigFeature::values);
        }
    }
}

