/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.capability;

import com.beanbot.instrumentus.common.items.datacomponents.InstrumentusDataComponents;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.energy.EnergyStorage;

public class EnergyItemstack
extends EnergyStorage {
    protected final ItemStack itemStack;

    public EnergyItemstack(int capacity, ItemStack itemStack) {
        super(capacity, capacity, capacity, 0);
        this.itemStack = itemStack;
        this.energy = (Integer)itemStack.getOrDefault(InstrumentusDataComponents.FORGE_ENERGY, (Object)0);
    }

    public void setEnergy(int energy) {
        this.energy = energy;
        this.itemStack.set(InstrumentusDataComponents.FORGE_ENERGY, (Object)energy);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
            this.itemStack.set(InstrumentusDataComponents.FORGE_ENERGY, (Object)this.energy);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
            this.itemStack.set(InstrumentusDataComponents.FORGE_ENERGY, (Object)this.energy);
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return (Integer)this.itemStack.getOrDefault(InstrumentusDataComponents.FORGE_ENERGY, (Object)0);
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return this.maxExtract > 0;
    }

    public boolean canReceive() {
        return this.maxReceive > 0;
    }

    public Tag serializeNBT(HolderLookup.Provider provider) {
        return IntTag.valueOf((int)this.getEnergyStored());
    }

    public void deserializeNBT(HolderLookup.Provider provider, Tag nbt) {
        if (!(nbt instanceof IntTag)) {
            throw new IllegalArgumentException("Can not deserialize to an instance that isn't the default implementation");
        }
        IntTag intNbt = (IntTag)nbt;
        this.energy = intNbt.getAsInt();
    }
}

