/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.blocks;

import com.beanbot.instrumentus.common.data.attachments.InstrumentusDataAttachments;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class WindBlowerBlock
extends Block {
    public static final int MIN_CHARGES = 0;
    public static final int MAX_CHARGES = 4;
    public static final IntegerProperty BLOWER_CHARGE = IntegerProperty.create((String)"blower_charges", (int)0, (int)4);

    public WindBlowerBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.POLISHED_TUFF).strength(2.0f).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BLOWER_CHARGE, (Comparable)Integer.valueOf(0)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(Items.BREEZE_ROD) && (Integer)state.getValue((Property)BLOWER_CHARGE) < 4) {
            BlockState blockState = (BlockState)state.setValue((Property)BLOWER_CHARGE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)BLOWER_CHARGE) + 1));
            level.setBlock(pos, blockState, 3);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)blockState));
            if (!((BlockPos)player.getData(InstrumentusDataAttachments.BOUND_WIND_BLOWER)).equals((Object)hitResult.getBlockPos())) {
                player.setData(InstrumentusDataAttachments.BOUND_WIND_BLOWER, (Object)hitResult.getBlockPos());
                player.displayClientMessage((Component)Component.translatable((String)"instrumentus.tooltip.bound_wind_blower", (Object[])new Object[]{String.format("%s", hitResult.getBlockPos().toShortString())}), true);
            }
            if ((Integer)state.getValue((Property)BLOWER_CHARGE) == 0) {
                level.playLocalSound(pos, SoundEvents.BREEZE_CHARGE, SoundSource.BLOCKS, 1.0f, 0.5f, false);
            } else if ((Integer)state.getValue((Property)BLOWER_CHARGE) == 1) {
                level.playLocalSound(pos, SoundEvents.BREEZE_CHARGE, SoundSource.BLOCKS, 1.0f, 0.75f, false);
            } else if ((Integer)state.getValue((Property)BLOWER_CHARGE) == 2) {
                level.playLocalSound(pos, SoundEvents.BREEZE_CHARGE, SoundSource.BLOCKS, 1.0f, 1.25f, false);
            } else if ((Integer)state.getValue((Property)BLOWER_CHARGE) == 3) {
                level.playLocalSound(pos, SoundEvents.BREEZE_CHARGE, SoundSource.BLOCKS, 1.0f, 1.75f, false);
            }
            level.addParticle((ParticleOptions)ParticleTypes.WHITE_SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 1.25, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
            stack.consume(1, (LivingEntity)player);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (!((BlockPos)player.getData(InstrumentusDataAttachments.BOUND_WIND_BLOWER)).equals((Object)hitResult.getBlockPos())) {
            player.setData(InstrumentusDataAttachments.BOUND_WIND_BLOWER, (Object)hitResult.getBlockPos());
            player.displayClientMessage((Component)Component.translatable((String)"instrumentus.tooltip.bound_wind_blower", (Object[])new Object[]{String.format("%s", hitResult.getBlockPos().toShortString())}), true);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return hand == InteractionHand.MAIN_HAND && player.getItemInHand(InteractionHand.OFF_HAND).is(Items.BREEZE_ROD) && (Integer)state.getValue((Property)BLOWER_CHARGE) < 4 ? ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if ((Integer)state.getValue((Property)BLOWER_CHARGE) == 0) {
            return InteractionResult.PASS;
        }
        if (((BlockPos)player.getData(InstrumentusDataAttachments.BOUND_WIND_BLOWER)).equals((Object)hitResult.getBlockPos())) {
            return InteractionResult.PASS;
        }
        player.setData(InstrumentusDataAttachments.BOUND_WIND_BLOWER, (Object)hitResult.getBlockPos());
        return InteractionResult.SUCCESS;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BLOWER_CHARGE, (Comparable)Integer.valueOf(0));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BLOWER_CHARGE});
    }

    public void preventionSoundAndParticles(Level level, BlockPos pos) {
        level.addParticle((ParticleOptions)ParticleTypes.WHITE_SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 1.25, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.WHITE_SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.WHITE_SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 1.75, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.WHITE_SMOKE, (double)pos.getX() + 0.5, (double)(pos.getY() + 2), (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.WHITE_SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 2.25, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.WHITE_SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 2.5, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.WHITE_SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 2.75, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.WHITE_SMOKE, (double)pos.getX() + 0.5, (double)(pos.getY() + 3), (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.WHITE_SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 3.25, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.GUST, (double)pos.getX() + 0.5, (double)pos.getY() + 3.5, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
        level.playLocalSound(pos, (SoundEvent)SoundEvents.WIND_CHARGE_BURST.value(), SoundSource.BLOCKS, 1.0f, 0.5f, false);
        level.playLocalSound(pos, SoundEvents.PHANTOM_DEATH, SoundSource.BLOCKS, 0.25f, 1.0f, false);
    }
}

