/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.blocks;

import com.beanbot.instrumentus.common.blocks.entities.CopperSoulCampfireBlockEntity;
import com.beanbot.instrumentus.common.blocks.entities.InstrumentusBlockEntities;
import com.beanbot.instrumentus.common.recipe.CopperSoulCampfireRecipe;
import java.util.Optional;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.stats.Stats;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CopperSoulCampfireBlock
extends CampfireBlock {
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);

    public CopperSoulCampfireBlock() {
        super(false, 3, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SOUL_CAMPFIRE).strength(2.0f).sound(SoundType.WOOD).lightLevel(CopperSoulCampfireBlock.litBlockEmission(15)).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)SIGNAL_FIRE, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack itemstack;
        CopperSoulCampfireBlockEntity soulCampfireBlockEntity;
        Optional<RecipeHolder<CopperSoulCampfireRecipe>> optional;
        BlockEntity blockentity = pLevel.getBlockEntity(pPos);
        if (blockentity instanceof CopperSoulCampfireBlockEntity && (optional = (soulCampfireBlockEntity = (CopperSoulCampfireBlockEntity)blockentity).getCookableRecipe(itemstack = pPlayer.getItemInHand(pHand))).isPresent()) {
            if (!pLevel.isClientSide && soulCampfireBlockEntity.placeFood((Entity)pPlayer, pPlayer.getAbilities().instabuild ? itemstack.copy() : itemstack, ((CopperSoulCampfireRecipe)optional.get().value()).getCookingTime())) {
                pPlayer.awardStat(Stats.INTERACT_WITH_CAMPFIRE);
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockentity = world.getBlockEntity(pos);
            if (blockentity instanceof CopperSoulCampfireBlockEntity) {
                Containers.dropContents((Level)world, (BlockPos)pos, ((CopperSoulCampfireBlockEntity)blockentity).getItems());
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CopperSoulCampfireBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> blockEntityType) {
        if (world.isClientSide) {
            return (Boolean)state.getValue((Property)LIT) != false ? CopperSoulCampfireBlock.createTickerHelper(blockEntityType, InstrumentusBlockEntities.COPPER_SOUL_CAMPFIRE_BLOCK_ENTITY.get(), CopperSoulCampfireBlockEntity::particleTick) : null;
        }
        return (Boolean)state.getValue((Property)LIT) != false ? CopperSoulCampfireBlock.createTickerHelper(blockEntityType, InstrumentusBlockEntities.COPPER_SOUL_CAMPFIRE_BLOCK_ENTITY.get(), CopperSoulCampfireBlockEntity::cookTick) : CopperSoulCampfireBlock.createTickerHelper(blockEntityType, InstrumentusBlockEntities.COPPER_SOUL_CAMPFIRE_BLOCK_ENTITY.get(), CopperSoulCampfireBlockEntity::cooldownTick);
    }

    private static ToIntFunction<BlockState> litBlockEmission(int lightValue) {
        return e -> (Boolean)e.getValue((Property)BlockStateProperties.LIT) != false ? lightValue : 0;
    }
}

