/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.client.ponder;

import com.beanbot.instrumentus.client.ponder.scenes.EnergizedScenes;
import com.beanbot.instrumentus.client.ponder.scenes.PaxelScenes;
import com.beanbot.instrumentus.client.ponder.scenes.SickleScenes;
import com.beanbot.instrumentus.client.ponder.scenes.SoulCopperScenes;
import com.beanbot.instrumentus.client.ponder.scenes.WindBlowerScenes;
import com.beanbot.instrumentus.common.items.EnergyLightningRodItem;
import com.beanbot.instrumentus.common.items.InstrumentusItems;
import com.beanbot.instrumentus.common.items.PaxelItem;
import com.beanbot.instrumentus.common.items.SickleItem;
import net.createmod.ponder.api.registration.PonderSceneRegistrationHelper;
import net.createmod.ponder.api.scene.PonderStoryBoard;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.DeferredHolder;

public class InstrumentusPonderScenes {
    public static void register(PonderSceneRegistrationHelper<ResourceLocation> helper) {
        for (DeferredHolder item : InstrumentusItems.ITEMS_REGISTRAR.getEntries()) {
            if (item.get() instanceof PaxelItem) {
                InstrumentusPonderScenes.add("paxel/mining", item.getId().getPath(), helper, PaxelScenes::paxelsMining);
                InstrumentusPonderScenes.add("paxel/stripping_pathing", item.getId().getPath(), helper, PaxelScenes::paxelsStrippingPathing);
                continue;
            }
            if (item.get() instanceof SickleItem) {
                InstrumentusPonderScenes.add("sickle/mining", item.getId().getPath(), helper, SickleScenes::sicklesMining);
                InstrumentusPonderScenes.add("sickle/mining_upgraded", item.getId().getPath(), helper, SickleScenes::sicklesMiningUpgraded);
                InstrumentusPonderScenes.add("sickle/vegetation", item.getId().getPath(), helper, SickleScenes::sicklesVegetationHarvesting);
                continue;
            }
            if (item.is(InstrumentusItems.WIND_BLOWER.getKey())) {
                InstrumentusPonderScenes.add("wind_blower/wind_blower", item.getId().getPath(), helper, WindBlowerScenes::windBlower);
                continue;
            }
            if (item.get() instanceof EnergyLightningRodItem || item.is(InstrumentusItems.ENERGIZED_INGOT.getKey()) || item.is(InstrumentusItems.ENERGIZED_BLOCK.getKey())) {
                InstrumentusPonderScenes.add("energized/lightning_rod", item.getId().getPath(), helper, EnergizedScenes::lightningRod);
                continue;
            }
            if (!item.is(InstrumentusItems.COPPER_SOUL_CAMPFIRE_BLOCK_ITEM.getKey()) && !item.is(InstrumentusItems.SOULCOPPER_INGOT.getKey()) && !item.is(InstrumentusItems.RAW_SOULCOPPER.getKey())) continue;
            InstrumentusPonderScenes.add("soulcopper/smelting", item.getId().getPath(), helper, SoulCopperScenes::soulCopperSmelting);
            if (!ModList.get().isLoaded("create")) continue;
            InstrumentusPonderScenes.add("soulcopper/fan_processing", item.getId().getPath(), helper, SoulCopperScenes::soulCopperFanProcessing);
        }
    }

    public static void add(String schematicId, String storyBoardId, PonderSceneRegistrationHelper<ResourceLocation> helper, PonderStoryBoard storyBoard) {
        helper.addStoryBoard((Object)ResourceLocation.fromNamespaceAndPath((String)"instrumentus", (String)storyBoardId), schematicId, storyBoard, new ResourceLocation[0]).highlightAllTags();
    }

    public static void add(String schematicId, int index, String storyBoardId, PonderSceneRegistrationHelper<ResourceLocation> helper, PonderStoryBoard storyBoard) {
        String schematicPath = schematicId + "_" + index;
        helper.addStoryBoard((Object)ResourceLocation.fromNamespaceAndPath((String)"instrumentus", (String)storyBoardId), schematicPath, storyBoard, new ResourceLocation[0]).highlightAllTags();
    }
}

