/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.client.events;

import com.beanbot.instrumentus.common.items.ExcavatorItem;
import com.beanbot.instrumentus.common.items.HammerItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;

public class ToolRenderEvents {
    @SubscribeEvent
    static void renderBlockOutline(RenderHighlightEvent.Block event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        Level world = player.level();
        ItemStack stack = player.getMainHandItem();
        if (!(!stack.isEmpty() && stack.getItem() instanceof HammerItem || stack.getItem() instanceof ExcavatorItem)) {
            return;
        }
        BlockHitResult blockTrace = event.getTarget();
        BlockPos origin = blockTrace.getBlockPos();
        BlockState state = world.getBlockState(origin);
        if (!state.canHarvestBlock((BlockGetter)world, origin, (Player)player)) {
            return;
        }
        Vec3 cameraPos = event.getCamera().getPosition();
        double cX = cameraPos.x();
        double cY = cameraPos.y();
        double cZ = cameraPos.z();
        VertexConsumer vertexConsumer = event.getMultiBufferSource().getBuffer((RenderType)RenderType.LINES);
        if (stack.isCorrectToolForDrops(state)) {
            int range = 3;
            List<BlockPos> affectedBlocks = ToolRenderEvents.getAffectedBlocks(world, (Player)player);
            for (BlockPos blockPos : affectedBlocks) {
                if (blockPos.equals((Object)origin)) continue;
                ToolRenderEvents.renderHitOutline(event.getPoseStack(), vertexConsumer, (Entity)player, cX, cY, cZ, world, blockPos, world.getBlockState(blockPos));
            }
        }
    }

    private static void renderHitOutline(PoseStack poseStack, VertexConsumer vertexConsumer, Entity player, double cX, double cY, double cZ, Level world, BlockPos blockPos, BlockState blockState) {
        ToolRenderEvents.renderShape(poseStack, vertexConsumer, blockState.getShape((BlockGetter)world, blockPos, CollisionContext.of((Entity)player)), (double)blockPos.getX() - cX, (double)blockPos.getY() - cY, (double)blockPos.getZ() - cZ);
    }

    private static void renderShape(PoseStack poseStack, VertexConsumer vertexConsumer, VoxelShape shape, double x, double y, double z) {
        PoseStack.Pose posestack$pose = poseStack.last();
        shape.forAllEdges((p_234280_, p_234281_, p_234282_, p_234283_, p_234284_, p_234285_) -> {
            float f = (float)(p_234283_ - p_234280_);
            float f1 = (float)(p_234284_ - p_234281_);
            float f2 = (float)(p_234285_ - p_234282_);
            float f3 = Mth.sqrt((float)(f * f + f1 * f1 + f2 * f2));
            vertexConsumer.addVertex(posestack$pose.pose(), (float)(p_234280_ + x), (float)(p_234281_ + y), (float)(p_234282_ + z)).setColor(0.0f, 0.0f, 0.0f, 0.2f).setNormal(posestack$pose, f /= f3, f1 /= f3, f2 /= f3);
            vertexConsumer.addVertex(posestack$pose.pose(), (float)(p_234283_ + x), (float)(p_234284_ + y), (float)(p_234285_ + z)).setColor(0.0f, 0.0f, 0.0f, 0.2f).setNormal(posestack$pose, f, f1, f2);
        });
    }

    public static List<BlockPos> getAffectedBlocks(Level world, Player player) {
        ArrayList<BlockPos> affectedBlocks;
        block6: {
            int aoeRadius;
            Direction blockFaceMined;
            BlockPos targetBlockPos;
            block8: {
                block7: {
                    affectedBlocks = new ArrayList<BlockPos>();
                    double maxDistance = 5.0;
                    HitResult result = player.pick(maxDistance, 0.0f, false);
                    if (result.getType() != HitResult.Type.BLOCK) break block6;
                    BlockHitResult blockHitResult = (BlockHitResult)result;
                    targetBlockPos = blockHitResult.getBlockPos();
                    blockFaceMined = blockHitResult.getDirection();
                    aoeRadius = 1;
                    if (blockFaceMined != Direction.EAST && blockFaceMined != Direction.WEST) break block7;
                    for (int dz = -aoeRadius; dz <= aoeRadius; ++dz) {
                        for (int dy = -aoeRadius; dy <= aoeRadius; ++dy) {
                            BlockPos blockPos;
                            BlockState state;
                            if (dy == 0 && dz == 0 || (state = world.getBlockState(blockPos = targetBlockPos.offset(0, dy, dz))).getBlock() == Blocks.AIR || !state.canHarvestBlock((BlockGetter)world, blockPos, player)) continue;
                            affectedBlocks.add(blockPos);
                        }
                    }
                    break block6;
                }
                if (blockFaceMined != Direction.NORTH && blockFaceMined != Direction.SOUTH) break block8;
                for (int dx = -aoeRadius; dx <= aoeRadius; ++dx) {
                    for (int dy = -aoeRadius; dy <= aoeRadius; ++dy) {
                        BlockPos blockPos;
                        BlockState state;
                        if (dy == 0 && dx == 0 || (state = world.getBlockState(blockPos = targetBlockPos.offset(dx, dy, 0))).getBlock() == Blocks.AIR || !state.canHarvestBlock((BlockGetter)world, blockPos, player)) continue;
                        affectedBlocks.add(blockPos);
                    }
                }
                break block6;
            }
            if (blockFaceMined != Direction.UP && blockFaceMined != Direction.DOWN) break block6;
            for (int dx = -aoeRadius; dx <= aoeRadius; ++dx) {
                for (int dz = -aoeRadius; dz <= aoeRadius; ++dz) {
                    BlockPos blockPos;
                    BlockState state;
                    if (dz == 0 && dx == 0 || (state = world.getBlockState(blockPos = targetBlockPos.offset(dx, 0, dz))).getBlock() == Blocks.AIR || !state.canHarvestBlock((BlockGetter)world, blockPos, player)) continue;
                    affectedBlocks.add(blockPos);
                }
            }
        }
        return affectedBlocks;
    }
}

