/*
 * Decompiled with CFR 0.152.
 */
package com.periut.chisel;

import com.periut.chisel.Chisel;
import com.periut.chisel.block.ChiselGroupLookup;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

@EmiEntrypoint
public class ChiselEMI
implements EmiPlugin {
    private static final ChiselCategory CHISEL_CATEGORY = new ChiselCategory();

    public void register(EmiRegistry registry) {
        registry.addCategory((EmiRecipeCategory)CHISEL_CATEGORY);
        registry.addWorkstation((EmiRecipeCategory)CHISEL_CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)Chisel.chiselSupplier.get())));
        Iterator<String> chiselGroupNames = ChiselGroupLookup.getGroupNameIterator();
        while (chiselGroupNames.hasNext()) {
            registry.addRecipe((EmiRecipe)new ChiselEmiRecipe(chiselGroupNames.next()));
        }
    }

    public static class ChiselCategory
    extends EmiRecipeCategory {
        public ChiselCategory() {
            super(ResourceLocation.fromNamespaceAndPath((String)"chisel", (String)"chisel_recipes_category"), (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)Chisel.chiselSupplier.get())));
        }

        public Component getName() {
            return Component.nullToEmpty((String)I18n.get((String)"rei.chisel.category", (Object[])new Object[0]));
        }
    }

    public static class ChiselEmiRecipe
    implements EmiRecipe {
        private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"chisel", (String)"textures/rei_recipes.png");
        private final ResourceLocation id;
        private final List<EmiIngredient> input;
        private final List<EmiStack> output;

        public ChiselEmiRecipe(String chiselGroup) {
            this.id = ResourceLocation.fromNamespaceAndPath((String)"chisel", (String)chiselGroup);
            this.input = new ArrayList<EmiIngredient>();
            this.output = new ArrayList<EmiStack>();
            for (Item item : ChiselGroupLookup.getBlocksInGroup(chiselGroup)) {
                this.input.add((EmiIngredient)EmiStack.of((ItemLike)item));
                this.output.add(EmiStack.of((ItemLike)item));
            }
        }

        public EmiRecipeCategory getCategory() {
            return CHISEL_CATEGORY;
        }

        @Nullable
        public ResourceLocation getId() {
            return this.id;
        }

        public List<EmiIngredient> getInputs() {
            return this.input;
        }

        public List<EmiStack> getOutputs() {
            return this.output;
        }

        public int getDisplayHeight() {
            return 200;
        }

        public int getDisplayWidth() {
            return 150;
        }

        public void addWidgets(WidgetHolder widgets) {
            int startX = 20;
            int startY = 4;
            int j = this.output.size();
            int rows = (int)Math.ceil((double)j / 6.0);
            widgets.addTexture(TEXTURE, 21, 15, 108, 236 - (18 * (10 - rows) + 11), 0, 10);
            widgets.addSlot(this.input.get(0), startX + 46, startY + 17).drawBack(false);
            for (int x = 0; x < 6; ++x) {
                for (int y = 0; y < rows && 6 * y + x < j; ++y) {
                    widgets.addSlot((EmiIngredient)this.output.get(6 * y + x), startX + 1 + 18 * x, startY + 56 + 18 * y).drawBack(false).recipeContext((EmiRecipe)this);
                }
            }
        }
    }
}

