/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.blocks.BlockSaw;
import mob_grinding_utils.client.ModelLayers;
import mob_grinding_utils.models.ModelSawBase;
import mob_grinding_utils.models.ModelSawBlade;
import mob_grinding_utils.tile.TileEntitySaw;
import mob_grinding_utils.util.RL;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TileEntitySawRenderer
implements BlockEntityRenderer<TileEntitySaw> {
    private static final ResourceLocation BASE_TEXTURE = RL.mgu("textures/tiles/saw_base.png");
    private static final ResourceLocation BLADE_TEXTURE = RL.mgu("textures/tiles/saw_blade.png");
    private final ModelSawBase saw_base;
    private final ModelSawBlade saw_blade;

    public TileEntitySawRenderer(BlockEntityRendererProvider.Context context) {
        this.saw_base = new ModelSawBase(context.bakeLayer(ModelLayers.SAW_BASE));
        this.saw_blade = new ModelSawBlade(context.bakeLayer(ModelLayers.SAW_BLADE));
    }

    public void render(@Nonnull TileEntitySaw tile, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (tile == null || !tile.hasLevel()) {
            return;
        }
        BlockState state = tile.getLevel().getBlockState(tile.getBlockPos());
        if (state == null || state.getBlock() != ModBlocks.SAW.getBlock()) {
            return;
        }
        Direction facing = (Direction)state.getValue((Property)BlockSaw.FACING);
        VertexConsumer ivertexbuilder = buffer.getBuffer(RenderType.entitySolid((ResourceLocation)BASE_TEXTURE));
        matrixStack.pushPose();
        matrixStack.translate(0.5, 0.5, 0.5);
        matrixStack.scale(-1.0f, -1.0f, 1.0f);
        switch (facing) {
            case UP: {
                matrixStack.mulPose(Axis.YP.rotationDegrees(0.0f));
                break;
            }
            case DOWN: {
                matrixStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                break;
            }
            case NORTH: {
                matrixStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case SOUTH: {
                matrixStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                break;
            }
            case WEST: {
                matrixStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                break;
            }
            case EAST: {
                matrixStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
            }
        }
        matrixStack.translate(0.0f, -1.0f, 0.0f);
        this.saw_base.renderToBuffer(matrixStack, ivertexbuilder, combinedLight, OverlayTexture.NO_OVERLAY, -1);
        matrixStack.pushPose();
        float ticks = (float)tile.animationTicks + (float)(tile.animationTicks - tile.prevAnimationTicks) * partialTicks;
        matrixStack.mulPose(Axis.YP.rotationDegrees(ticks));
        this.saw_base.renderAxle(matrixStack, ivertexbuilder, combinedLight, OverlayTexture.NO_OVERLAY, -1);
        matrixStack.pushPose();
        matrixStack.mulPose(Axis.YP.rotationDegrees(45.0f));
        this.saw_base.renderMace(matrixStack, ivertexbuilder, combinedLight, OverlayTexture.NO_OVERLAY, -1);
        matrixStack.popPose();
        matrixStack.pushPose();
        matrixStack.mulPose(Axis.YP.rotationDegrees(165.0f));
        this.saw_base.renderMace(matrixStack, ivertexbuilder, combinedLight, OverlayTexture.NO_OVERLAY, -1);
        matrixStack.popPose();
        matrixStack.pushPose();
        matrixStack.mulPose(Axis.YP.rotationDegrees(285.0f));
        this.saw_base.renderMace(matrixStack, ivertexbuilder, combinedLight, OverlayTexture.NO_OVERLAY, -1);
        matrixStack.popPose();
        matrixStack.pushPose();
        matrixStack.translate(0.0f, 0.2f, -0.16f);
        matrixStack.mulPose(Axis.XP.rotationDegrees(8.0f));
        this.saw_blade.renderToBuffer(matrixStack, buffer.getBuffer(RenderType.entitySolid((ResourceLocation)BLADE_TEXTURE)), combinedLight, OverlayTexture.NO_OVERLAY, -1);
        matrixStack.popPose();
        matrixStack.pushPose();
        matrixStack.translate(0.0f, 0.0f, 0.16f);
        matrixStack.mulPose(Axis.XP.rotationDegrees(-8.0f));
        this.saw_blade.renderToBuffer(matrixStack, buffer.getBuffer(RenderType.entitySolid((ResourceLocation)BLADE_TEXTURE)), combinedLight, OverlayTexture.NO_OVERLAY, -1);
        matrixStack.popPose();
        matrixStack.pushPose();
        matrixStack.translate(0.0f, -0.2f, -0.16f);
        matrixStack.mulPose(Axis.XP.rotationDegrees(8.0f));
        this.saw_blade.renderToBuffer(matrixStack, buffer.getBuffer(RenderType.entitySolid((ResourceLocation)BLADE_TEXTURE)), combinedLight, OverlayTexture.NO_OVERLAY, -1);
        matrixStack.popPose();
        matrixStack.popPose();
        matrixStack.popPose();
    }
}

