/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.critterarmory.layer;

import com.jahirtrap.critterarmory.init.ModModelLayers;
import com.jahirtrap.critterarmory.item.BaseAnimalArmorItem;
import com.jahirtrap.critterarmory.util.CommonUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.ChickenModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ChickenArmorLayer
extends RenderLayer<Chicken, ChickenModel<Chicken>> {
    private final ChickenModel<Chicken> model;

    public ChickenArmorLayer(RenderLayerParent<Chicken, ChickenModel<Chicken>> layerParent, EntityModelSet modelSet) {
        super(layerParent);
        this.model = new ChickenModel(modelSet.bakeLayer(ModModelLayers.CHICKEN_ARMOR));
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int i, Chicken entity, float f, float g, float h, float j, float k, float l) {
        ItemStack stack = entity.getBodyArmorItem();
        Item item = stack.getItem();
        if (item instanceof BaseAnimalArmorItem.Modded) {
            BaseAnimalArmorItem.Modded animalArmorItem = (BaseAnimalArmorItem.Modded)item;
            ((ChickenModel)this.getParentModel()).copyPropertiesTo(this.model);
            this.model.prepareMobModel((Entity)entity, f, g, h);
            this.model.setupAnim((Entity)entity, f, g, j, k, l);
            CommonUtils.renderArmor(ResourceLocation.parse((String)animalArmorItem.getMaterial().getRegisteredName()), this.model, stack, poseStack, bufferSource, i);
        }
    }
}

