/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.critterarmory.init.mixin;

import com.jahirtrap.critterarmory.item.BaseAnimalArmorItem;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AnimalArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Wolf.class})
public abstract class WolfMixin {
    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    public void mobInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        Wolf entity = (Wolf)this;
        ItemStack stack = player.getItemInHand(hand);
        if (entity.isTame() && this.isBodyArmorItem(stack) && entity.isOwnedBy((LivingEntity)player) && !entity.isWearingBodyArmor() && !entity.isBaby()) {
            entity.setBodyArmorItem(stack.copyWithCount(1));
            stack.consume(1, (LivingEntity)player);
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }

    @Inject(method={"hasArmor"}, at={@At(value="HEAD")}, cancellable=true)
    public void hasArmor(CallbackInfoReturnable<Boolean> cir) {
        Wolf entity = (Wolf)this;
        if (this.isBodyArmorItem(entity.getBodyArmorItem())) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"canArmorAbsorb"}, at={@At(value="HEAD")}, cancellable=true)
    public void canArmorAbsorb(DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        Wolf entity = (Wolf)this;
        if (this.isBodyArmorItem(entity.getBodyArmorItem())) {
            cir.setReturnValue((Object)false);
        }
    }

    @Unique
    public boolean isBodyArmorItem(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BaseAnimalArmorItem.Vanilla) {
            BaseAnimalArmorItem.Vanilla animalArmorItem = (BaseAnimalArmorItem.Vanilla)item;
            return animalArmorItem.getBodyType() == AnimalArmorItem.BodyType.CANINE;
        }
        return false;
    }
}

