/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.critterarmory.init.mixin;

import com.jahirtrap.critterarmory.item.BaseAnimalArmorItem;
import com.jahirtrap.critterarmory.util.CommonUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.neoforge.common.ItemAbilities;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Animal.class})
public abstract class AnimalMixin {
    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    public void mobInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        Animal entity = (Animal)this;
        ItemStack stack = player.getItemInHand(hand);
        if (CommonUtils.canFeed((LivingEntity)entity) && this.tamable(player) && CommonUtils.feedEntity(player, hand, entity)) {
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
        if (CommonUtils.canWearArmor((LivingEntity)entity)) {
            if (this.isEquippableInSlot(stack, EquipmentSlot.BODY) && !entity.isWearingBodyArmor() && !entity.isBaby()) {
                entity.setBodyArmorItem(stack.copyWithCount(1));
                stack.consume(1, (LivingEntity)player);
                cir.setReturnValue((Object)InteractionResult.SUCCESS);
            } else if (this.shearable() && (stack.getItem() instanceof ShearsItem || stack.canPerformAction(ItemAbilities.SHEARS_REMOVE_ARMOR)) && entity.getBodyArmorItem().getItem() instanceof BaseAnimalArmorItem.Modded && (!EnchantmentHelper.has((ItemStack)entity.getBodyArmorItem(), (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE) || player.isCreative())) {
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                entity.playSound(SoundEvents.ARMOR_UNEQUIP_WOLF);
                ItemStack armor = entity.getBodyArmorItem();
                entity.setBodyArmorItem(ItemStack.EMPTY);
                entity.spawnAtLocation(armor);
                cir.setReturnValue((Object)InteractionResult.SUCCESS);
            }
        }
    }

    @Unique
    private boolean isEquippableInSlot(ItemStack stack, EquipmentSlot slot) {
        BaseAnimalArmorItem.Modded animalArmorItem;
        Item item;
        Animal entity = (Animal)this;
        return entity.canUseSlot(slot) && (item = stack.getItem()) instanceof BaseAnimalArmorItem.Modded && (animalArmorItem = (BaseAnimalArmorItem.Modded)item).getType().getSlot() == slot && animalArmorItem.getAllowedEntities().contains((Holder)entity.getType().builtInRegistryHolder());
    }

    @Unique
    private boolean shearable() {
        Shearable shearable;
        Animal animal = (Animal)this;
        return !(animal instanceof Shearable) || !(shearable = (Shearable)animal).readyForShearing();
    }

    @Unique
    private boolean tamable(Player player) {
        TamableAnimal tamable;
        Animal animal = (Animal)this;
        return !(animal instanceof TamableAnimal) || (tamable = (TamableAnimal)animal).isTame() && tamable.isOwnedBy((LivingEntity)player);
    }
}

