/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.modular_angelring.render;

import com.leclowndu93150.modular_angelring.registry.ItemRegistry;
import com.leclowndu93150.modular_angelring.render.AngelRingCheck;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import top.theillusivec4.curios.api.CuriosApi;

public class AngelRingRenderer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    protected static final double FLAP_FREQUENCY = 0.5;
    protected static final double MAX_ANGLE = 25.0;
    protected double angle = 0.0;
    private final double dir;

    public AngelRingRenderer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> playerModel, boolean isRightWing) {
        super(playerModel);
        this.dir = isRightWing ? 1.0 : -1.0;
    }

    public void render(@NotNull PoseStack matrixStack, @NotNull MultiBufferSource buffer, int packedLight, @NotNull AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Optional slotResult = CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(handler -> handler.findFirstCurio((Item)ItemRegistry.ANGEL_RING.get()));
        if (slotResult.isEmpty()) {
            return;
        }
        if (!player.isInvisible() && AngelRingCheck.isEquipped(player) && AngelRingCheck.isVisible(player)) {
            matrixStack.pushPose();
            ((PlayerModel)this.getParentModel()).body.translateAndRotate(matrixStack);
            matrixStack.translate(this.dir * -0.5, 0.1, 0.35);
            matrixStack.scale(0.9f, 0.9f, 0.9f);
            matrixStack.mulPose(new Quaternionf().rotateXYZ(0.0f, (float)(1.5707963267948966 - this.dir * 1.0471975511965979), (float)Math.PI));
            matrixStack.translate(-0.5, 0.0, 0.0);
            this.updateWingAngle();
            matrixStack.mulPose(Axis.YN.rotationDegrees((float)this.angle));
            matrixStack.translate(0.5, 0.0, 0.0);
            switch (AngelRingCheck.getWingType(player)) {
                case "BAT": {
                    Minecraft.getInstance().getItemRenderer().renderStatic((LivingEntity)player, new ItemStack((ItemLike)ItemRegistry.BAT_WINGS_BOTH.get()), ItemDisplayContext.NONE, false, matrixStack, buffer, player.level(), 0xF000F0, OverlayTexture.NO_OVERLAY, player.getId());
                    break;
                }
                case "BUTTERFLY": {
                    Minecraft.getInstance().getItemRenderer().renderStatic((LivingEntity)player, new ItemStack((ItemLike)ItemRegistry.BUTTERFLY_WINGS_BOTH.get()), ItemDisplayContext.NONE, false, matrixStack, buffer, player.level(), 0xF000F0, OverlayTexture.NO_OVERLAY, player.getId());
                    break;
                }
                case "DRAGON": {
                    Minecraft.getInstance().getItemRenderer().renderStatic((LivingEntity)player, new ItemStack((ItemLike)ItemRegistry.DRAGON_WINGS_BOTH.get()), ItemDisplayContext.NONE, false, matrixStack, buffer, player.level(), 0xF000F0, OverlayTexture.NO_OVERLAY, player.getId());
                    break;
                }
                case "BIG_DRAGON": {
                    Minecraft.getInstance().getItemRenderer().renderStatic((LivingEntity)player, new ItemStack((ItemLike)ItemRegistry.BIG_DRAGON_WINGS_BOTH.get()), ItemDisplayContext.NONE, false, matrixStack, buffer, player.level(), 0xF000F0, OverlayTexture.NO_OVERLAY, player.getId());
                    break;
                }
                case "BLUE_DRAGON": {
                    Minecraft.getInstance().getItemRenderer().renderStatic((LivingEntity)player, new ItemStack((ItemLike)ItemRegistry.BLUE_DRAGON_WINGS_BOTH.get()), ItemDisplayContext.NONE, false, matrixStack, buffer, player.level(), 0xF000F0, OverlayTexture.NO_OVERLAY, player.getId());
                    break;
                }
                case "GOLD": {
                    Minecraft.getInstance().getItemRenderer().renderStatic((LivingEntity)player, new ItemStack((ItemLike)ItemRegistry.GOLD_WINGS_BOTH.get()), ItemDisplayContext.NONE, false, matrixStack, buffer, player.level(), 0xF000F0, OverlayTexture.NO_OVERLAY, player.getId());
                    break;
                }
                case "GOLDEN": {
                    Minecraft.getInstance().getItemRenderer().renderStatic((LivingEntity)player, new ItemStack((ItemLike)ItemRegistry.GOLDEN_WINGS_BOTH.get()), ItemDisplayContext.NONE, false, matrixStack, buffer, player.level(), 0xF000F0, OverlayTexture.NO_OVERLAY, player.getId());
                    break;
                }
                case "ANGEL": {
                    Minecraft.getInstance().getItemRenderer().renderStatic((LivingEntity)player, new ItemStack((ItemLike)ItemRegistry.ANGEL_WINGS_BOTH.get()), ItemDisplayContext.NONE, false, matrixStack, buffer, player.level(), 0xF000F0, OverlayTexture.NO_OVERLAY, player.getId());
                    break;
                }
            }
            matrixStack.popPose();
        }
    }

    private void updateWingAngle() {
        this.angle = this.dir * 25.0 * Math.sin(Math.PI * ((double)System.currentTimeMillis() / 1000.0));
    }
}

