/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.modular_angelring.registry;

import com.leclowndu93150.modular_angelring.networking.NoKeyPressedPayload;
import com.leclowndu93150.modular_angelring.registry.DataComponentRegistry;
import com.leclowndu93150.modular_angelring.registry.ItemRegistry;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

@EventBusSubscriber(modid="modular_angelring", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class KeyBindRegistry {
    public static final Lazy<KeyMapping> INERTIA_MODULE = Lazy.of(() -> new KeyMapping("Inertia Module", InputConstants.Type.KEYSYM, 76, "Modular Angel Ring"));
    public static final Lazy<KeyMapping> SPEED_MODULE = Lazy.of(() -> new KeyMapping("Speed Module", InputConstants.Type.KEYSYM, 75, "Modular Angel Ring"));
    public static final Lazy<KeyMapping> NIGHT_VISION_MODULE = Lazy.of(() -> new KeyMapping("Night Vision Module", InputConstants.Type.KEYSYM, 78, "Modular Angel Ring"));
    public static final Lazy<KeyMapping> MAGNET_MODULE = Lazy.of(() -> new KeyMapping("Magnet Module", InputConstants.Type.KEYSYM, 80, "Modular Angel Ring"));

    @SubscribeEvent
    public static void registerBindings(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)SPEED_MODULE.get());
        event.register((KeyMapping)INERTIA_MODULE.get());
        event.register((KeyMapping)NIGHT_VISION_MODULE.get());
        event.register((KeyMapping)MAGNET_MODULE.get());
    }

    @EventBusSubscriber(modid="modular_angelring", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
    public static class Client {
        @SubscribeEvent
        public static void clientTick(ClientTickEvent.Post event) {
            Minecraft mc = Minecraft.getInstance();
            Options opt = mc.options;
            LocalPlayer player = mc.player;
            Optional slotResult = CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(handler -> handler.findFirstCurio((Item)ItemRegistry.ANGEL_RING.get()));
            if (mc.level != null && mc.level.isClientSide() && slotResult.isPresent() && ((SlotResult)slotResult.get()).stack().has(DataComponentRegistry.INERTIA_MODIFIER)) {
                CompoundTag persistentData = player.getPersistentData();
                if (opt.keyUp.isDown() || opt.keyDown.isDown() || opt.keyLeft.isDown() || opt.keyRight.isDown()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new NoKeyPressedPayload(false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    persistentData.putBoolean("no_keys_pressed", false);
                } else {
                    PacketDistributor.sendToServer((CustomPacketPayload)new NoKeyPressedPayload(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    persistentData.putBoolean("no_keys_pressed", true);
                }
            }
        }
    }
}

