/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.modular_angelring.common;

import com.leclowndu93150.modular_angelring.AngelRingConfig;
import com.leclowndu93150.modular_angelring.common.AngelRingModules;
import com.leclowndu93150.modular_angelring.common.EnabledModifiersComponent;
import com.leclowndu93150.modular_angelring.registry.AttachementRegistry;
import com.leclowndu93150.modular_angelring.registry.DataComponentRegistry;
import com.leclowndu93150.modular_angelring.registry.ItemRegistry;
import com.leclowndu93150.modular_angelring.utils.FlightSpeedPercentage;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForgeMod;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class AngelRingItem
extends Item {
    public AngelRingItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent evt) {
        evt.registerItem(CuriosCapability.ITEM, (stack, context) -> new ICurio(){

            public ItemStack getStack() {
                return ItemRegistry.ANGEL_RING.toStack();
            }

            public void curioTick(SlotContext slotContext) {
                Player player = (Player)slotContext.entity();
                Optional slotResult = CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(handler -> handler.findFirstCurio((Item)ItemRegistry.ANGEL_RING.get()));
                if (slotResult.isPresent()) {
                    MobEffectInstance effect;
                    ItemStack angelRingStack = ((SlotResult)slotResult.get()).stack();
                    EnabledModifiersComponent data = (EnabledModifiersComponent)angelRingStack.getOrDefault(DataComponentRegistry.MODIFIERS_ENABLED, (Object)EnabledModifiersComponent.EMPTY);
                    if (angelRingStack.has(DataComponentRegistry.SPEED_MODIFIER) && (player.getAbilities().getFlyingSpeed() != AngelRingModules.getSpeedModifier(angelRingStack).floatValue() || !data.speedModifierEnabled())) {
                        if (data.speedModifierEnabled()) {
                            if (player.getAbilities().flying) {
                                player.getAbilities().setFlyingSpeed(AngelRingModules.getSpeedModifier(angelRingStack).floatValue());
                            }
                        } else {
                            player.getAbilities().setFlyingSpeed(0.05f);
                        }
                    }
                    if (angelRingStack.has(DataComponentRegistry.NIGHT_VISION_MODIFIER) && data.nightVisionEnabled() && ((effect = player.getEffect(MobEffects.NIGHT_VISION)) == null || effect.getDuration() < 219)) {
                        player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 400, 0, true, false));
                    }
                }
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                Player player = (Player)slotContext.entity();
                AngelRingItem.startFlight(player);
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                Player player = (Player)slotContext.entity();
                AngelRingItem.stopFlight(player);
                player.getAbilities().setFlyingSpeed(0.05f);
                player.removeEffect(MobEffects.NIGHT_VISION);
                AttachementRegistry.setNightVision(player, false);
            }
        }, new ItemLike[]{(ItemLike)ItemRegistry.ANGEL_RING.get()});
    }

    public int getMaxStackSize(@NotNull ItemStack stack) {
        return 1;
    }

    public boolean isFoil(@NotNull ItemStack pStack) {
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player player, InteractionHand pUsedHand) {
        float MAX_FLY_SPEED = (float)AngelRingConfig.maxFlightSpeed;
        float MIN_FLY_SPEED = 0.0f;
        float SPEED_INCREMENT = 0.005f;
        ItemStack item = player.getItemInHand(pUsedHand);
        if (item.is((Item)this) && item.has(DataComponentRegistry.SPEED_MODIFIER)) {
            float currentFlySpeed = AngelRingModules.getSpeedModifier(item).floatValue();
            if (player.isShiftKeyDown()) {
                currentFlySpeed = Math.max(currentFlySpeed - 0.005f, 0.0f);
            } else if (currentFlySpeed < MAX_FLY_SPEED) {
                currentFlySpeed = Math.min(currentFlySpeed + 0.005f, MAX_FLY_SPEED);
            }
            AngelRingModules.setSpeedModifier(item, Float.valueOf(currentFlySpeed));
            int percentage = FlightSpeedPercentage.speedToPercentage(currentFlySpeed);
            player.displayClientMessage((Component)Component.literal((String)"Speed: ").append(String.valueOf(percentage)).append("%").withStyle(ChatFormatting.WHITE), true);
            player.level().playSound(player, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundEvents.NOTE_BLOCK_BELL.value(), SoundSource.PLAYERS, 0.4f, 0.01f);
            return InteractionResultHolder.success((Object)item);
        }
        return InteractionResultHolder.fail((Object)item);
    }

    private static void startFlight(Player player) {
        player.getAttribute(NeoForgeMod.CREATIVE_FLIGHT).setBaseValue(1.0);
    }

    private static void stopFlight(Player player) {
        player.getAttribute(NeoForgeMod.CREATIVE_FLIGHT).setBaseValue(0.0);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext pContext, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pTooltipFlag) {
        EnabledModifiersComponent data = (EnabledModifiersComponent)stack.getOrDefault(DataComponentRegistry.MODIFIERS_ENABLED, (Object)EnabledModifiersComponent.EMPTY);
        if (AngelRingModules.getMiningSpeedModifier(stack).booleanValue()) {
            pTooltipComponents.add((Component)Component.literal((String)"Mining Module").withStyle(ChatFormatting.GRAY));
        }
        if (AngelRingModules.getInertiaModifier(stack).booleanValue() && data.inertiaEnabled()) {
            pTooltipComponents.add((Component)Component.literal((String)"Inertia Module: ").append("Enabled").withStyle(ChatFormatting.GREEN));
        }
        if (AngelRingModules.getInertiaModifier(stack).booleanValue() && !data.inertiaEnabled()) {
            pTooltipComponents.add((Component)Component.literal((String)"Inertia Module: ").append("Disabled").withStyle(ChatFormatting.RED));
        }
        if (stack.has(DataComponentRegistry.SPEED_MODIFIER) && data.speedModifierEnabled()) {
            pTooltipComponents.add((Component)Component.literal((String)"Speed Module: ").append(String.valueOf(FlightSpeedPercentage.speedToPercentage(AngelRingModules.getSpeedModifier(stack).floatValue()))).append("%").withStyle(ChatFormatting.GREEN));
        }
        if (stack.has(DataComponentRegistry.SPEED_MODIFIER) && !data.speedModifierEnabled()) {
            pTooltipComponents.add((Component)Component.literal((String)"Speed Module: ").append(String.valueOf(FlightSpeedPercentage.speedToPercentage(AngelRingModules.getSpeedModifier(stack).floatValue()))).append("%").withStyle(ChatFormatting.RED));
        }
        if (AngelRingModules.getNightVisionModifier(stack).booleanValue() && data.nightVisionEnabled()) {
            pTooltipComponents.add((Component)Component.literal((String)"Night Vision Module: ").append("Enabled").withStyle(ChatFormatting.GREEN));
        }
        if (AngelRingModules.getNightVisionModifier(stack).booleanValue() && !data.nightVisionEnabled()) {
            pTooltipComponents.add((Component)Component.literal((String)"Night Vision Module: ").append("Disabled").withStyle(ChatFormatting.RED));
        }
        if (AngelRingModules.getMagnetModifier(stack).booleanValue() && data.magnetEnabled()) {
            pTooltipComponents.add((Component)Component.literal((String)"Magnet Module: ").append("Enabled").withStyle(ChatFormatting.GREEN).append(" (Radius: ").append(String.valueOf((int)AngelRingConfig.magnetRadius)).append(" blocks)").withStyle(ChatFormatting.GREEN));
        }
        if (AngelRingModules.getMagnetModifier(stack).booleanValue() && !data.magnetEnabled()) {
            pTooltipComponents.add((Component)Component.literal((String)"Magnet Module: ").append("Disabled").withStyle(ChatFormatting.RED));
        }
        super.appendHoverText(stack, pContext, pTooltipComponents, pTooltipFlag);
    }
}

