/*
 * Decompiled with CFR 0.152.
 */
package thelm.packageddraconic.recipe;

import com.brandon3055.draconicevolution.init.DEContent;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.ArrayUtils;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.api.IRecipeSlotViewWrapper;
import thelm.packagedauto.api.IRecipeSlotsViewWrapper;
import thelm.packageddraconic.recipe.FusionPackageRecipeInfo;

public class FusionPackageRecipeType
implements IPackageRecipeType {
    public static final FusionPackageRecipeType INSTANCE;
    public static final ResourceLocation NAME;
    public static final IntSet SLOTS;
    public static final List<ResourceLocation> CATEGORIES;
    public static final Vec3i COLOR;
    public static final Vec3i COLOR_CENTER;
    public static final Vec3i COLOR_DISABLED;

    public ResourceLocation getName() {
        return NAME;
    }

    public MutableComponent getDisplayName() {
        return Component.translatable((String)"recipe.packageddraconic.fusion");
    }

    public MutableComponent getShortDisplayName() {
        return Component.translatable((String)"recipe.packageddraconic.fusion.short");
    }

    public MapCodec<? extends IPackageRecipeInfo> getRecipeInfoMapCodec() {
        return FusionPackageRecipeInfo.MAP_CODEC;
    }

    public Codec<? extends IPackageRecipeInfo> getRecipeInfoCodec() {
        return FusionPackageRecipeInfo.CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, ? extends IPackageRecipeInfo> getRecipeInfoStreamCodec() {
        return FusionPackageRecipeInfo.STREAM_CODEC;
    }

    public IPackageRecipeInfo generateRecipeInfoFromStacks(List<ItemStack> inputs, List<ItemStack> outputs, Level level) {
        return new FusionPackageRecipeInfo(inputs, level);
    }

    public IntSet getEnabledSlots() {
        return SLOTS;
    }

    public boolean hasCraftingRemainingItem() {
        return false;
    }

    public List<ResourceLocation> getJEICategories() {
        return CATEGORIES;
    }

    public Int2ObjectMap<ItemStack> getRecipeTransferMap(IRecipeSlotsViewWrapper recipeLayoutWrapper) {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        List slotViews = recipeLayoutWrapper.getRecipeSlotViews();
        int index = 0;
        int[] slotArray = SLOTS.toIntArray();
        ArrayUtils.shift((int[])slotArray, (int)0, (int)28, (int)1);
        for (IRecipeSlotViewWrapper slotView : slotViews) {
            if (slotView.isInput()) {
                ItemStack stack;
                Object displayed = slotView.getDisplayedIngredient().orElse(null);
                if (displayed instanceof ItemStack && !(stack = (ItemStack)displayed).isEmpty()) {
                    map.put(slotArray[index], (Object)stack);
                }
                ++index;
            }
            if (index < 55) continue;
            break;
        }
        return map;
    }

    public Object getRepresentation() {
        return new ItemStack((ItemLike)DEContent.CRAFTING_CORE.get());
    }

    public Vec3i getSlotColor(int slot) {
        if (!SLOTS.contains(slot) && slot != 81) {
            return COLOR_DISABLED;
        }
        if (slot == 40) {
            return COLOR_CENTER;
        }
        return COLOR;
    }

    static {
        int i;
        INSTANCE = new FusionPackageRecipeType();
        NAME = ResourceLocation.parse((String)"packageddraconic:fusion");
        CATEGORIES = List.of(ResourceLocation.parse((String)"draconicevolution:fusion_crafting"));
        COLOR = new Vec3i(139, 139, 139);
        COLOR_CENTER = new Vec3i(179, 139, 179);
        COLOR_DISABLED = new Vec3i(64, 64, 64);
        SLOTS = new IntRBTreeSet();
        for (i = 1; i < 8; ++i) {
            for (int j = 1; j < 8; ++j) {
                SLOTS.add(9 * i + j);
            }
        }
        for (i = 3; i < 6; ++i) {
            SLOTS.add(9 * i);
            SLOTS.add(9 * i + 8);
        }
    }
}

