/*
 * Decompiled with CFR 0.152.
 */
package thelm.packageddraconic.packet;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import thelm.packageddraconic.block.entity.MarkedInjectorBlockEntity;

public record SyncInjectorPacket(BlockPos pos, long op, long req) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncInjectorPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.parse((String)"packageddraconic:sync_injector"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncInjectorPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SyncInjectorPacket::pos, (StreamCodec)ByteBufCodecs.VAR_LONG, SyncInjectorPacket::op, (StreamCodec)ByteBufCodecs.VAR_LONG, SyncInjectorPacket::req, SyncInjectorPacket::new);

    public SyncInjectorPacket(MarkedInjectorBlockEntity injector) {
        this(injector.getBlockPos(), injector.getInjectorEnergy(), injector.getEnergyRequirement());
    }

    public CustomPacketPayload.Type<SyncInjectorPacket> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            BlockEntity be;
            ClientLevel level = Minecraft.getInstance().level;
            if (level.isLoaded(this.pos) && (be = level.getBlockEntity(this.pos)) instanceof MarkedInjectorBlockEntity) {
                MarkedInjectorBlockEntity injector = (MarkedInjectorBlockEntity)be;
                injector.setInjectorEnergy(this.op);
                injector.setEnergyRequirement(this.req, 0L);
            }
        });
    }

    public static void sync(MarkedInjectorBlockEntity injector) {
        Level level = injector.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            double x = (double)injector.getBlockPos().getX() + 0.5;
            double y = (double)injector.getBlockPos().getY() + 0.5;
            double z = (double)injector.getBlockPos().getZ() + 0.5;
            PacketDistributor.sendToPlayersNear((ServerLevel)level2, null, (double)x, (double)y, (double)z, (double)32.0, (CustomPacketPayload)new SyncInjectorPacket(injector), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

