/*
 * Decompiled with CFR 0.152.
 */
package thelm.packageddraconic.packet;

import com.brandon3055.draconicevolution.api.crafting.IFusionStateMachine;
import java.util.function.IntFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import thelm.packageddraconic.block.entity.FusionCrafterBlockEntity;

public record SyncCrafterPacket(BlockPos pos, IFusionStateMachine.FusionState fusionState, short progress, float animProgress, short animLength) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncCrafterPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.parse((String)"packageddraconic:sync_crafter"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncCrafterPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SyncCrafterPacket::pos, (StreamCodec)ByteBufCodecs.idMapper((IntFunction)ByIdMap.continuous(Enum::ordinal, (Object[])IFusionStateMachine.FusionState.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO), Enum::ordinal), SyncCrafterPacket::fusionState, (StreamCodec)ByteBufCodecs.SHORT, SyncCrafterPacket::progress, (StreamCodec)ByteBufCodecs.FLOAT, SyncCrafterPacket::animProgress, (StreamCodec)ByteBufCodecs.SHORT, SyncCrafterPacket::animLength, SyncCrafterPacket::new);

    public SyncCrafterPacket(FusionCrafterBlockEntity crafter) {
        this(crafter.getBlockPos(), crafter.fusionState, crafter.progress, crafter.animProgress, crafter.animLength);
    }

    public CustomPacketPayload.Type<SyncCrafterPacket> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            BlockEntity be;
            ClientLevel level = Minecraft.getInstance().level;
            if (level.isLoaded(this.pos) && (be = level.getBlockEntity(this.pos)) instanceof FusionCrafterBlockEntity) {
                FusionCrafterBlockEntity crafter = (FusionCrafterBlockEntity)be;
                crafter.fusionState = this.fusionState;
                crafter.progress = this.progress;
                crafter.animProgress = this.animProgress;
                crafter.animLength = this.animLength;
            }
        });
    }

    public static void sync(FusionCrafterBlockEntity crafter) {
        Level level = crafter.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            double x = (double)crafter.getBlockPos().getX() + 0.5;
            double y = (double)crafter.getBlockPos().getY() + 0.5;
            double z = (double)crafter.getBlockPos().getZ() + 0.5;
            PacketDistributor.sendToPlayersNear((ServerLevel)level2, null, (double)x, (double)y, (double)z, (double)32.0, (CustomPacketPayload)new SyncCrafterPacket(crafter), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

