/*
 * Decompiled with CFR 0.152.
 */
package thelm.packageddraconic.op;

import com.brandon3055.brandonscore.api.power.OPStorage;
import net.minecraft.nbt.CompoundTag;
import thelm.packageddraconic.block.entity.MarkedInjectorBlockEntity;
import thelm.packageddraconic.packet.SyncInjectorPacket;

public class MarkedInjectorOPStorage
extends OPStorage {
    public final MarkedInjectorBlockEntity blockEntity;
    public long energy;
    public long energyReq;
    public long chargeRate;

    public MarkedInjectorOPStorage(MarkedInjectorBlockEntity blockEntity) {
        super(0L);
        this.blockEntity = blockEntity;
    }

    public long receiveOP(long maxReceive, boolean simulate) {
        long opStored = this.getOPStored();
        long received = Math.max(Math.min(this.getMaxOPStored() - opStored, Math.min(maxReceive, this.chargeRate)), 0L);
        if (!simulate && received > 0L) {
            this.energy += received;
            if (!this.blockEntity.getLevel().isClientSide) {
                this.blockEntity.setChanged();
                SyncInjectorPacket.sync(this.blockEntity);
            }
        }
        return received;
    }

    public boolean canReceive() {
        return true;
    }

    public long getOPStored() {
        return this.energy;
    }

    public long getMaxOPStored() {
        return this.energyReq;
    }

    public MarkedInjectorOPStorage load(CompoundTag nbt) {
        this.energy = nbt.getLong("energy");
        this.energyReq = nbt.getLong("energy_req");
        this.chargeRate = nbt.getLong("charge_rate");
        return this;
    }

    public void save(CompoundTag nbt) {
        if (this.energy < 0L) {
            this.energy = 0L;
        }
        nbt.putLong("energy", this.energy);
        nbt.putLong("energy_req", this.energyReq);
        nbt.putLong("charge_rate", this.chargeRate);
    }

    public void setEnergyStored(long energy) {
        if (energy < 0L) {
            energy = 0L;
        }
        boolean flag = this.energy != energy;
        this.energy = energy;
        if (flag && !this.blockEntity.getLevel().isClientSide) {
            this.blockEntity.setChanged();
            SyncInjectorPacket.sync(this.blockEntity);
        }
    }
}

