/*
 * Decompiled with CFR 0.152.
 */
package thelm.packageddraconic.inventory;

import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.inventory.BaseItemHandler;
import thelm.packageddraconic.block.entity.FusionCrafterBlockEntity;
import thelm.packageddraconic.inventory.FusionCrafterItemHandlerWrapper;

public class FusionCrafterItemHandler
extends BaseItemHandler<FusionCrafterBlockEntity> {
    public FusionCrafterItemHandler(FusionCrafterBlockEntity blockEntity) {
        super((BaseBlockEntity)blockEntity, 3);
    }

    protected void onContentsChanged(int slot) {
        if (slot < 2) {
            this.sync(false);
        }
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot == 2) {
            return stack.getCapability(Capabilities.EnergyStorage.ITEM) != null;
        }
        return false;
    }

    public IItemHandlerModifiable getWrapperForDirection(Direction side) {
        return this.wrapperMap.computeIfAbsent(side, s -> new FusionCrafterItemHandlerWrapper(this, (Direction)s));
    }

    public int get(int id) {
        return switch (id) {
            case 0 -> ((FusionCrafterBlockEntity)this.blockEntity).progress;
            case 1 -> {
                if (((FusionCrafterBlockEntity)this.blockEntity).isWorking) {
                    yield 1;
                }
                yield 0;
            }
            case 2 -> ((FusionCrafterBlockEntity)this.blockEntity).getEnergyStorage().getEnergyStored();
            default -> 0;
        };
    }

    public void set(int id, int value) {
        switch (id) {
            case 0: {
                ((FusionCrafterBlockEntity)this.blockEntity).progress = (short)value;
                break;
            }
            case 1: {
                ((FusionCrafterBlockEntity)this.blockEntity).isWorking = value != 0;
                break;
            }
            case 2: {
                ((FusionCrafterBlockEntity)this.blockEntity).getEnergyStorage().setEnergyStored(value);
            }
        }
    }

    public int getCount() {
        return 3;
    }
}

