/*
 * Decompiled with CFR 0.152.
 */
package thelm.packageddraconic.integration.patchouli.processor;

import com.brandon3055.draconicevolution.api.crafting.IFusionRecipe;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import thelm.packagedauto.util.MiscHelper;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class FusionRecipeProcessor
implements IComponentProcessor {
    public static final NumberFormat ENERGY_FORMAT = new DecimalFormat("#,##0");
    IFusionRecipe fusionRecipe;

    public void setup(Level level, IVariableProvider variables) {
        ResourceLocation recipeId = ResourceLocation.parse((String)variables.get("recipe", (HolderLookup.Provider)level.registryAccess()).asString());
        Recipe recipe = MiscHelper.INSTANCE.getRecipeManager().byKey(recipeId).map(RecipeHolder::value).orElse(null);
        if (recipe instanceof IFusionRecipe) {
            IFusionRecipe fusionRecipe;
            this.fusionRecipe = fusionRecipe = (IFusionRecipe)recipe;
        }
    }

    public IVariable process(Level level, String key) {
        if (this.fusionRecipe != null) {
            if (key.equals("catalyst")) {
                return IVariable.from((Object)this.fusionRecipe.getCatalyst(), (HolderLookup.Provider)level.registryAccess());
            }
            if (key.equals("output")) {
                return IVariable.from((Object)this.fusionRecipe.getResultItem((HolderLookup.Provider)level.registryAccess()), (HolderLookup.Provider)level.registryAccess());
            }
            if (key.equals("tier")) {
                return IVariable.from((Object)Component.translatable((String)("gui.draconicevolution.fusion_craft.tier." + this.fusionRecipe.getRecipeTier().name().toLowerCase(Locale.US))), (HolderLookup.Provider)level.registryAccess());
            }
            if (key.equals("tier_color")) {
                int tier = this.fusionRecipe.getRecipeTier().index;
                return IVariable.wrap((String)(tier == 0 ? "5050FF" : (tier == 1 ? "8000FF" : (tier == 2 ? "FF6600" : "505050"))), (HolderLookup.Provider)level.registryAccess());
            }
            if (key.equals("energy")) {
                return IVariable.wrap((String)(ENERGY_FORMAT.format(this.fusionRecipe.getEnergyCost()) + " OP"), (HolderLookup.Provider)level.registryAccess());
            }
        }
        return null;
    }
}

