/*
 * Decompiled with CFR 0.152.
 */
package thelm.packageddraconic.client.screen;

import com.brandon3055.brandonscore.BCConfig;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import thelm.packagedauto.client.screen.BaseScreen;
import thelm.packagedauto.menu.BaseMenu;
import thelm.packageddraconic.block.entity.FusionCrafterBlockEntity;
import thelm.packageddraconic.menu.FusionCrafterMenu;

public class FusionCrafterScreen
extends BaseScreen<FusionCrafterMenu> {
    public static final ResourceLocation BACKGROUND_LIGHT = ResourceLocation.parse((String)"packageddraconic:textures/gui/fusion_crafter_light.png");
    public static final ResourceLocation BACKGROUND_DARK = ResourceLocation.parse((String)"packageddraconic:textures/gui/fusion_crafter_dark.png");

    public FusionCrafterScreen(FusionCrafterMenu menu, Inventory inventory, Component title) {
        super((BaseMenu)menu, inventory, title);
    }

    protected ResourceLocation getBackgroundTexture() {
        return BCConfig.darkMode ? BACKGROUND_DARK : BACKGROUND_LIGHT;
    }

    public void init() {
        this.clearWidgets();
        super.init();
        this.addRenderableWidget((GuiEventListener)new ButtonTheme(this.leftPos + 161, this.topPos + 3));
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(graphics, partialTicks, mouseX, mouseY);
        graphics.blit(this.getBackgroundTexture(), this.leftPos + 75, this.topPos + 35, 176, 0, ((FusionCrafterBlockEntity)((FusionCrafterMenu)this.menu).blockEntity).getScaledProgress(22), 16);
        int scaledEnergy = ((FusionCrafterBlockEntity)((FusionCrafterMenu)this.menu).blockEntity).getScaledEnergy(40);
        graphics.blit(this.getBackgroundTexture(), this.leftPos + 10, this.topPos + 10 + 40 - scaledEnergy, 176, 56 - scaledEnergy, 12, scaledEnergy);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        String s = ((FusionCrafterBlockEntity)((FusionCrafterMenu)this.menu).blockEntity).getDisplayName().getString();
        int color = BCConfig.darkMode ? 11514291 : 0x111111;
        graphics.drawString(this.font, s, Math.max(25, this.imageWidth / 2 - this.font.width(s) / 2), 6, color, false);
        graphics.drawString(this.font, ((FusionCrafterMenu)this.menu).inventory.getDisplayName().getString(), ((FusionCrafterMenu)this.menu).getPlayerInvX(), ((FusionCrafterMenu)this.menu).getPlayerInvY() - 11, color, false);
        if (mouseX - this.leftPos >= 10 && mouseY - this.topPos >= 10 && mouseX - this.leftPos <= 21 && mouseY - this.topPos <= 49) {
            graphics.renderTooltip(this.font, (Component)Component.literal((String)(((FusionCrafterBlockEntity)((FusionCrafterMenu)this.menu).blockEntity).getEnergyStorage().getEnergyStored() + " / " + ((FusionCrafterBlockEntity)((FusionCrafterMenu)this.menu).blockEntity).getEnergyStorage().getMaxEnergyStored() + " FE")), mouseX - this.leftPos, mouseY - this.topPos);
        }
    }

    class ButtonTheme
    extends AbstractButton {
        final Tooltip lightTooltip;
        final Tooltip darkTooltip;

        public ButtonTheme(int x, int y) {
            super(x, y, 12, 12, (Component)Component.empty());
            this.lightTooltip = Tooltip.create((Component)Component.translatable((String)"gui_tkt.brandonscore.theme.light"));
            this.darkTooltip = Tooltip.create((Component)Component.translatable((String)"gui_tkt.brandonscore.theme.dark"));
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            this.setTooltip(BCConfig.darkMode ? this.lightTooltip : this.darkTooltip);
            super.renderWidget(graphics, mouseX, mouseY, partialTicks);
            if (this.isHoveredOrFocused()) {
                graphics.fill(this.getX(), this.getY(), this.getX() + 12, this.getY() + 12, BCConfig.darkMode ? -12100758 : -10191953);
            }
            graphics.blit(FusionCrafterScreen.this.getBackgroundTexture(), this.getX(), this.getY(), 176, 56, 12, 12);
        }

        public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }

        public void onPress() {
            BCConfig.modifyClientProperty((String)"darkMode", e -> e.setBoolean(!BCConfig.darkMode), (String[])new String[0]);
        }
    }
}

