/*
 * Decompiled with CFR 0.152.
 */
package thelm.packageddraconic.client.renderer;

import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.vec.Quat;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.draconicevolution.client.AtlasTextureHelper;
import com.brandon3055.draconicevolution.client.render.EffectLib;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import thelm.packagedauto.client.RenderTimer;
import thelm.packageddraconic.block.entity.FusionCrafterBlockEntity;
import thelm.packageddraconic.client.fx.FusionCrafterFXHandler;

public class FusionCrafterRenderer
implements BlockEntityRenderer<FusionCrafterBlockEntity> {
    private static Random rand = new Random();
    private RenderType particleType = RenderType.create((String)"particle_type", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionColorTexLightmapShader)).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureAtlas.LOCATION_PARTICLES, false, false)).setWriteMaskState(new RenderStateShard.WriteMaskStateShard(true, true)).createCompositeState(false));

    public FusionCrafterRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(FusionCrafterBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        this.renderContent(blockEntity, partialTicks, poseStack, buffer, combinedLight, combinedOverlay);
        FusionCrafterFXHandler handler = (FusionCrafterFXHandler)blockEntity.fxHandler;
        if (handler.renderActive()) {
            this.renderEffects(blockEntity, handler, partialTicks, poseStack, buffer, combinedLight, combinedOverlay);
        }
    }

    private void renderContent(FusionCrafterBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int packetOverlay) {
        ItemStack stack = !blockEntity.getOutputStack().isEmpty() && !blockEntity.isWorking ? blockEntity.getOutputStack() : blockEntity.getCatalystStack();
        Minecraft mc = Minecraft.getInstance();
        if (!stack.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.5, 0.5, 0.5);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            poseStack.mulPose(Axis.YP.rotationDegrees(((float)RenderTimer.INSTANCE.getTicks() + partialTicks) * 0.8f));
            mc.getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, combinedLight, packetOverlay, poseStack, buffer, blockEntity.getLevel(), (int)blockEntity.getBlockPos().asLong());
            poseStack.popPose();
        }
    }

    private void renderEffects(FusionCrafterBlockEntity blockEntity, FusionCrafterFXHandler handler, float partialTicks, PoseStack poseStack, MultiBufferSource getter, int combinedLight, int packetOverlay) {
        Minecraft mc = Minecraft.getInstance();
        Camera camera = mc.gameRenderer.getMainCamera();
        int ticks = RenderTimer.INSTANCE.getTicks();
        float time = (float)ticks + partialTicks;
        poseStack.translate(0.5, 0.5, 0.5);
        ParticleStatus pStatus = (ParticleStatus)mc.options.particles().get();
        double particleSetting = pStatus == ParticleStatus.ALL ? 1.0 : (pStatus == ParticleStatus.DECREASED ? 0.6666666666666666 : 0.3333333333333333);
        int maxParticles = (int)(1000.0 * particleSetting);
        List<FusionCrafterFXHandler.IngredFX> ingredFXList = handler.getIngredients(partialTicks);
        int i = 0;
        for (FusionCrafterFXHandler.IngredFX ingred : ingredFXList) {
            this.renderIngredientEffect(camera, poseStack, getter, partialTicks, i++, ingred, maxParticles / ingredFXList.size());
            if (ingred.arcPos == null) continue;
            EffectLib.renderLightningP2PRotate((PoseStack)poseStack, (MultiBufferSource)getter, (Vector3)ingred.pos, (Vector3)ingred.arcPos, (int)8, (long)(ticks / 2), (float)0.06f, (float)0.04f, (boolean)false, (float)0.0f, (int)6488253);
        }
        Rotation cameraRotation = new Rotation(new Quat(camera.rotation()));
        TransformingVertexConsumer builder = new TransformingVertexConsumer(getter.getBuffer(this.particleType), poseStack);
        if (handler.injectTime > 0.0f) {
            rand.setSeed(3055L);
            double anim = handler.getRotationAnim(partialTicks);
            int chargePCount = 64;
            float pScale = 0.0625f;
            for (i = 0; i < chargePCount; ++i) {
                anim += rand.nextGaussian();
                float scale = Mth.clamp((float)(handler.injectTime * (float)chargePCount - (float)i), (float)0.0f, (float)1.0f) * pScale * (0.7f + rand.nextFloat() * 0.3f);
                if (scale <= 0.0f) break;
                float rotX = (float)((double)rand.nextFloat() * Math.PI * 2.0 + anim / 10.0);
                float rotY = (float)((double)rand.nextFloat() * Math.PI * 2.0 + anim / 15.0);
                double radius = 0.35 * MathUtils.clampMap((double)blockEntity.animProgress, (double)0.95f, (double)1.0, (double)1.0, (double)0.0);
                double x = radius * (double)Mth.cos((float)rotX) * (double)Mth.sin((float)rotY);
                double y = radius * (double)Mth.sin((float)rotX) * (double)Mth.sin((float)rotY);
                double z = radius * (double)Mth.cos((float)rotY);
                EffectLib.drawParticle((Rotation)cameraRotation, (VertexConsumer)builder, (TextureAtlasSprite)this.getTexture(AtlasTextureHelper.MIXED_PARTICLE), (float)1.0f, (float)0.0f, (float)0.0f, (double)x, (double)y, (double)z, (float)scale, (int)240);
            }
        }
        if (handler.chargeState > 0.0f) {
            double y;
            for (i = 0; i < 4; ++i) {
                float loopOffset = (float)i / 4.0f * (float)Math.PI * 2.0f + time / 100.0f;
                for (int j = 0; j < 8; ++j) {
                    float rot = (float)j / 64.0f * (float)Math.PI * 2.0f + time / 10.0f + loopOffset;
                    if ((float)j > handler.chargeState * 8.0f) continue;
                    double x = Mth.sin((float)rot) * 2.0f;
                    double z = Mth.cos((float)rot) * 2.0f;
                    y = Mth.cos((float)(rot + loopOffset)) * 1.0f;
                    float scale = 0.1f * ((float)j / 8.0f);
                    EffectLib.drawParticle((Rotation)cameraRotation, (VertexConsumer)builder, (TextureAtlasSprite)this.getTexture(AtlasTextureHelper.ENERGY_PARTICLE, j), (float)0.41568628f, (float)0.050980393f, (float)0.6784314f, (double)x, (double)y, (double)z, (float)scale, (int)240);
                }
            }
            if (handler.injectTime > 0.0f && ticks % 5 == 0) {
                int pos = rand.nextInt(4);
                for (i = 0; i < 4; ++i) {
                    if (i != pos) continue;
                    float loopOffset = (float)i / 4.0f * (float)Math.PI * 2.0f + time / 100.0f;
                    float rot = 0.68722343f + time / 10.0f + loopOffset;
                    double x = Mth.sin((float)rot) * 2.0f;
                    double z = Mth.cos((float)rot) * 2.0f;
                    y = Mth.cos((float)(rot + loopOffset)) * 1.0f;
                    EffectLib.renderLightningP2PRotate((PoseStack)poseStack, (MultiBufferSource)getter, (Vector3)new Vector3(x, y, z), (Vector3)Vector3.ZERO, (int)8, (long)(ticks / 2), (float)0.06f, (float)0.04f, (boolean)false, (float)0.0f, (int)6488253);
                }
            }
        }
    }

    private void renderIngredientEffect(Camera camera, PoseStack poseStack, MultiBufferSource getter, float partialTicks, long randSeed, FusionCrafterFXHandler.IngredFX ingred, int totalParticles) {
        Rotation cameraRotation = new Rotation(new Quat(camera.rotation()));
        TransformingVertexConsumer builder = new TransformingVertexConsumer(getter.getBuffer(this.particleType), poseStack);
        rand.setSeed(randSeed);
        double anim = ingred.getChargeAnim(partialTicks);
        int chargePCount = Math.min(64, totalParticles / 3);
        float pScale = 0.025f;
        for (int i = 0; i < chargePCount; ++i) {
            anim += rand.nextGaussian();
            float scale = Mth.clamp((float)(ingred.getCharge() * ingred.dieOut * (float)chargePCount - (float)i), (float)0.0f, (float)1.0f) * pScale * (0.7f + rand.nextFloat() * 0.3f);
            if (scale <= 0.0f) break;
            float rotX = (float)((double)rand.nextFloat() * Math.PI * 2.0 + anim / 10.0);
            float rotY = (float)((double)rand.nextFloat() * Math.PI * 2.0 + anim / 15.0);
            double radius = 0.25;
            double x = ingred.pos.x + radius * (double)Mth.cos((float)rotX) * (double)Mth.sin((float)rotY);
            double y = ingred.pos.y + radius * (double)Mth.sin((float)rotX) * (double)Mth.sin((float)rotY);
            double z = ingred.pos.z + radius * (double)Mth.cos((float)rotY);
            EffectLib.drawParticle((Rotation)cameraRotation, (VertexConsumer)builder, (TextureAtlasSprite)this.getTexture(AtlasTextureHelper.ENERGY_PARTICLE), (float)0.0f, (float)(0.8f + rand.nextFloat() * 0.2f), (float)1.0f, (double)x, (double)y, (double)z, (float)scale, (int)240);
        }
        int itemPCount = Math.min(48, totalParticles / 3);
        rand.setSeed(randSeed);
        anim = ingred.getChargeAnim(partialTicks);
        pScale = 0.0125f;
        Vector3 pos = new Vector3();
        for (int i = 0; i < itemPCount; ++i) {
            int seed = (int)Math.floor((anim += rand.nextDouble() * 69420.0) / 20.0);
            MathUtils.setRandSeed((long)seed);
            float pulse = (float)anim / 20.0f % 1.0f;
            float scale = Mth.clamp((float)(ingred.coreAnim * ingred.dieOut * (float)itemPCount - (float)i), (float)0.0f, (float)1.0f);
            if (scale <= 0.0f) break;
            scale = (float)((double)scale * (1.0 - Math.sin((double)pulse * Math.PI * 2.0)));
            pos.set((double)MathUtils.nextFloat(), (double)MathUtils.nextFloat(), (double)MathUtils.nextFloat());
            pos.subtract(0.5);
            pos.normalize();
            pos.multiply((double)MathUtils.nextFloat() * 0.1875);
            pos.add(ingred.pos);
            EffectLib.drawParticle((Rotation)cameraRotation, (VertexConsumer)builder, (TextureAtlasSprite)this.getTexture(AtlasTextureHelper.SPELL_PARTICLE), (float)0.7f, (float)0.0f, (float)0.0f, (double)pos.x, (double)pos.y, (double)pos.z, (float)(scale * pScale), (int)240);
        }
        double randOffset = 0.125;
        rand.setSeed(randSeed);
        anim = ingred.beamAnim;
        pScale = 0.025f;
        int beamPCount = Math.min(32, totalParticles / 3);
        if (ingred.beamAnim > 0.0f) {
            for (int i = 0; i < beamPCount; ++i) {
                anim += rand.nextDouble() * 64.0;
                float scale = Mth.clamp((float)(Math.min(1.0f, ingred.beamAnim / 60.0f) * ingred.dieOut * (float)beamPCount - (float)i), (float)0.0f, (float)1.0f) * pScale * (0.7f + rand.nextFloat() * 0.3f);
                if (scale <= 0.0f) break;
                Vector3 start = ingred.pos.copy().add((0.5 - rand.nextDouble()) * randOffset * 2.0, (0.5 - rand.nextDouble()) * randOffset * 2.0, (0.5 - rand.nextDouble()) * randOffset * 2.0);
                Vector3 end = new Vector3((0.5 - rand.nextDouble()) * randOffset * 2.0, (0.5 - rand.nextDouble()) * randOffset * 2.0, (0.5 - rand.nextDouble()) * randOffset * 2.0);
                pos = MathUtils.interpolateVec3((Vector3)start, (Vector3)end, (double)(anim / 10.0 % 1.0));
                EffectLib.drawParticle((Rotation)cameraRotation, (VertexConsumer)builder, (TextureAtlasSprite)this.getTexture(AtlasTextureHelper.SPARK_PARTICLE), (float)(0.7f + (float)anim / 10.0f % 1.0f * 0.3f), (float)0.0f, (float)0.0f, (double)pos.x, (double)pos.y, (double)pos.z, (float)scale, (int)240);
            }
        }
    }

    public TextureAtlasSprite getTexture(TextureAtlasSprite[] arr) {
        return arr[Math.floorMod(rand.nextInt(arr.length) + RenderTimer.INSTANCE.getTicks(), arr.length)];
    }

    public TextureAtlasSprite getTexture(TextureAtlasSprite[] arr, int shift) {
        return arr[Math.floorMod(shift + RenderTimer.INSTANCE.getTicks(), arr.length)];
    }

    public AABB getRenderBoundingBox(FusionCrafterBlockEntity blockEntity) {
        return new AABB(blockEntity.getBlockPos()).inflate(16.0);
    }
}

