/*
 * Decompiled with CFR 0.152.
 */
package thelm.packageddraconic.client.fx;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.draconicevolution.api.crafting.IFusionInjector;
import com.brandon3055.draconicevolution.api.crafting.IFusionRecipe;
import com.brandon3055.draconicevolution.api.crafting.IFusionStateMachine;
import com.brandon3055.draconicevolution.handlers.DESounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.entity.BlockEntity;
import thelm.packagedauto.client.RenderTimer;
import thelm.packageddraconic.block.entity.FusionCrafterBlockEntity;
import thelm.packageddraconic.block.entity.MarkedInjectorBlockEntity;
import thelm.packageddraconic.client.sound.FusionCrafterRotationSound;

public class FusionCrafterFXHandler
implements Runnable {
    private static Random rand = new Random();
    private final FusionCrafterBlockEntity crafter;
    private float rotationTick = 0.0f;
    private float rotationSpeed = 0.0f;
    private int coreDischarge = -1;
    private int baseCraftTime = 300;
    private int translateStartTime = 0;
    private int rotStartTime = 30;
    private int beamStartTime = 60;
    private int dieOutStart = 100;
    private float animRadius = 2.0f;
    public float injectTime = 0.0f;
    public float chargeState = 0.0f;
    private int runTick = 0;
    private FusionCrafterRotationSound sound = null;

    public FusionCrafterFXHandler(FusionCrafterBlockEntity crafter) {
        this.crafter = crafter;
    }

    @Override
    public void run() {
        RecipeHolder<IFusionRecipe> recipe;
        if (!this.crafter.isWorking || (recipe = this.crafter.effectRecipe) == null) {
            this.rotationTick = -3.0f;
            this.sound = null;
            this.injectTime = 0.0f;
            this.chargeState = 0.0f;
            this.runTick = -1;
            return;
        }
        IFusionStateMachine.FusionState state = this.crafter.getFusionState();
        if (state.ordinal() < IFusionStateMachine.FusionState.CRAFTING.ordinal()) {
            this.rotationTick = -3.0f;
            this.rotationSpeed = 0.0f;
            this.injectTime = 0.0f;
            this.runTick = -1;
        } else {
            float prevTick = this.rotationTick;
            Vector3 corePos = Vector3.fromTileCenter((BlockEntity)this.crafter);
            if (this.runTick <= 0) {
                this.crafter.getLevel().playLocalSound(corePos.x, corePos.y, corePos.z, (SoundEvent)DESounds.FUSION_COMPLETE.get(), SoundSource.BLOCKS, 0.5f, 0.5f, false);
            }
            if (this.runTick == -1) {
                this.getIngredients(0.0f).forEach(e -> this.crafter.getLevel().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, corePos.x + e.pos.x, corePos.y + e.pos.y, corePos.z + e.pos.z, 1.0, 0.0, 0.0));
            }
            this.rotationTick += this.rotationSpeed;
            ++this.runTick;
            this.rotationSpeed = (float)this.baseCraftTime / (float)Math.max(this.crafter.animLength, 1);
            if (this.rotationTick + 3.0f >= (float)this.rotStartTime && prevTick + 3.0f < (float)(this.rotStartTime + 3)) {
                this.crafter.getLevel().playLocalSound(corePos.x, corePos.y, corePos.z, (SoundEvent)DESounds.FUSION_COMPLETE.get(), SoundSource.BLOCKS, 2.0f, 0.5f, false);
                if (this.sound == null) {
                    this.sound = new FusionCrafterRotationSound(this.crafter);
                    this.sound.setPitch(0.5f + 1.5f * (this.rotationSpeed - 1.0f));
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)this.sound);
                }
            }
            this.injectTime = Math.max(0.0f, (this.rotationTick - (float)this.beamStartTime) / (float)(this.baseCraftTime - this.beamStartTime));
            if (this.injectTime > 0.0f && RenderTimer.INSTANCE.getTicks() % 5 == 0) {
                this.crafter.getLevel().playLocalSound(corePos.x, corePos.y, corePos.z, (SoundEvent)DESounds.ENERGY_BOLT.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
        }
        long totalCharge = this.crafter.getInjectors().stream().mapToLong(IFusionInjector::getInjectorEnergy).sum();
        this.chargeState = (float)totalCharge / (float)((IFusionRecipe)recipe.value()).getEnergyCost();
        float arcChance = this.chargeState * 0.1f + this.crafter.animProgress * 0.2f + (this.rotationSpeed > 1.0f ? (this.rotationSpeed - 1.0f) * 0.25f : 0.0f);
        if (this.coreDischarge != -1) {
            this.coreDischarge = -1;
        } else if (rand.nextFloat() < arcChance) {
            List<IngredFX> ingreds = this.getIngredients(0.0f);
            if (ingreds.isEmpty()) {
                return;
            }
            this.coreDischarge = rand.nextInt(ingreds.size());
            Vector3 pos = Vector3.fromTileCenter((BlockEntity)this.crafter).add(ingreds.get((int)this.coreDischarge).pos);
            this.crafter.getLevel().playLocalSound(pos.x, pos.y, pos.z, (SoundEvent)DESounds.ENERGY_BOLT.get(), SoundSource.BLOCKS, 2.0f, 1.0f, false);
        }
    }

    public List<IngredFX> getIngredients(float partialTicks) {
        ArrayList<IngredFX> ingredFXES = new ArrayList<IngredFX>();
        Vector3 corePos = Vector3.fromTileCenter((BlockEntity)this.crafter);
        int injCount = (int)this.crafter.getInjectors().stream().filter(e -> !e.getInjectorStack().isEmpty()).count();
        double baseRotateSpeed = 8.0;
        baseRotateSpeed /= 1200.0;
        baseRotateSpeed *= Math.PI * 2;
        float rotateAnim = this.getRotationAnim(partialTicks);
        int i = 0;
        for (IFusionInjector iInjector : this.crafter.getInjectors()) {
            if (iInjector.getInjectorStack().isEmpty()) continue;
            MarkedInjectorBlockEntity injector = (MarkedInjectorBlockEntity)iInjector;
            Vector3 injPos = Vector3.fromTileCenter((BlockEntity)injector).subtract(corePos);
            injPos.add(Vector3.fromVec3i((Vec3i)injector.getDirection().getNormal()).multiply(0.45));
            float startAngle = (float)i / (float)injCount * (float)Math.PI * 2.0f;
            startAngle = (float)((double)startAngle + (double)(rotateAnim >= (float)this.rotStartTime ? rotateAnim - (float)this.rotStartTime : 0.0f) * baseRotateSpeed);
            double x = Mth.cos((float)startAngle) * this.animRadius;
            double z = Mth.sin((float)startAngle) * this.animRadius;
            Vector3 animPos = new Vector3(x, 0.0, z);
            if (rotateAnim < (float)this.rotStartTime) {
                animPos = MathUtils.interpolateVec3((Vector3)injPos, (Vector3)animPos, (double)(this.rotationTick - (float)this.translateStartTime > 0.0f ? (double)((rotateAnim - (float)this.translateStartTime) / (float)(this.rotStartTime - this.translateStartTime)) : 0.0));
            }
            IngredFX ingredFX = new IngredFX(animPos, injector);
            if (i == this.coreDischarge) {
                ingredFX.arcPos = Vector3.ZERO;
            }
            if (rotateAnim > 0.0f) {
                ingredFX.coreAnim = Math.min(1.0f, rotateAnim / (float)this.translateStartTime * 2.0f);
            }
            ingredFX.beamAnim = rotateAnim - (float)this.beamStartTime;
            ingredFX.dieOut = Mth.clamp((float)(1.0f - (rotateAnim - (float)this.dieOutStart) / (float)(this.baseCraftTime - this.dieOutStart)), (float)0.0f, (float)1.0f);
            ingredFXES.add(ingredFX);
            ++i;
        }
        return ingredFXES;
    }

    public boolean renderActive() {
        return this.crafter.isWorking;
    }

    public float getRotationAnim(float partialTicks) {
        return this.rotationTick + this.rotationSpeed * partialTicks;
    }

    public static class IngredFX {
        public Vector3 pos;
        private IFusionInjector injector;
        public Vector3 arcPos = null;
        public float beamAnim = 0.0f;
        public float coreAnim = 0.0f;
        public float dieOut = 1.0f;

        public IngredFX(Vector3 pos, IFusionInjector injector) {
            this.pos = pos;
            this.injector = injector;
        }

        public double getChargeAnim(float partialTicks) {
            return (float)RenderTimer.INSTANCE.getTicks() + partialTicks;
        }

        public float getCharge() {
            return (float)this.injector.getInjectorEnergy() / (float)this.injector.getEnergyRequirement();
        }
    }
}

