/*
 * Decompiled with CFR 0.152.
 */
package thelm.packageddraconic.block.entity;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.crafting.IFusionInjector;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packageddraconic.block.MarkedInjectorBlock;
import thelm.packageddraconic.block.entity.FusionCrafterBlockEntity;
import thelm.packageddraconic.block.entity.PackagedDraconicBlockEntities;
import thelm.packageddraconic.inventory.MarkedInjectorItemHandler;
import thelm.packageddraconic.op.MarkedInjectorOPStorage;

public class MarkedInjectorBlockEntity
extends BaseBlockEntity
implements IFusionInjector {
    public MarkedInjectorOPStorage opStorage = new MarkedInjectorOPStorage(this);
    public BlockPos crafterPos = null;
    public int tier = -1;

    public MarkedInjectorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PackagedDraconicBlockEntities.MARKED_INJECTOR.get(), pos, state);
        this.setItemHandler(new MarkedInjectorItemHandler(this));
    }

    protected Component getDefaultName() {
        return this.getBlockState().getBlock().getName();
    }

    public void ejectItem() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        this.itemHandler.setStackInSlot(0, ItemStack.EMPTY);
        if (!stack.isEmpty()) {
            Direction direction = this.getDirection();
            double dx = (double)(this.level.random.nextFloat() / 2.0f) + 0.25 + (double)direction.getStepX() * 0.5;
            double dy = (double)(this.level.random.nextFloat() / 2.0f) + 0.25 + (double)direction.getStepY() * 0.5;
            double dz = (double)(this.level.random.nextFloat() / 2.0f) + 0.25 + (double)direction.getStepZ() * 0.5;
            ItemEntity itemEntity = new ItemEntity(this.level, (double)this.worldPosition.getX() + dx, (double)this.worldPosition.getY() + dy, (double)this.worldPosition.getZ() + dz, stack);
            itemEntity.setDefaultPickUpDelay();
            this.level.addFreshEntity((Entity)itemEntity);
        }
    }

    public boolean setCrafter(FusionCrafterBlockEntity crafter) {
        FusionCrafterBlockEntity oldCrafter = this.getCrafter();
        if (oldCrafter != null && oldCrafter != crafter && oldCrafter.isWorking) {
            oldCrafter.cancelCraft();
        }
        this.crafterPos = crafter == null ? null : crafter.getBlockPos();
        this.setEnergyRequirement(0L, 0L);
        this.sync(false);
        return true;
    }

    public FusionCrafterBlockEntity getCrafter() {
        FusionCrafterBlockEntity crafter;
        if (this.crafterPos == null || this.level == null) {
            return null;
        }
        BlockEntity be = this.level.getBlockEntity(this.crafterPos);
        return be instanceof FusionCrafterBlockEntity ? (crafter = (FusionCrafterBlockEntity)be) : null;
    }

    public TechLevel getInjectorTier() {
        Block block;
        if (this.tier == -1 && (block = this.level.getBlockState(this.worldPosition).getBlock()) instanceof MarkedInjectorBlock) {
            this.tier = ((MarkedInjectorBlock)block).tier;
        }
        return TechLevel.byIndex((int)this.tier);
    }

    public ItemStack getInjectorStack() {
        return this.itemHandler.getStackInSlot(0);
    }

    public void setInjectorStack(ItemStack stack) {
        this.itemHandler.setStackInSlot(0, stack);
    }

    public long getInjectorEnergy() {
        return this.opStorage.energy;
    }

    public void setInjectorEnergy(long energy) {
        this.opStorage.energy = energy;
        this.setChanged();
    }

    public void setEnergyRequirement(long maxEnergy, long chargeRate) {
        this.opStorage.energyReq = maxEnergy;
        this.opStorage.chargeRate = Math.max(chargeRate, 1L);
        this.setChanged();
    }

    public long getEnergyRequirement() {
        return this.opStorage.energyReq;
    }

    public boolean validate() {
        return !this.isRemoved() && this.level != null && this.level.getBlockEntity(this.worldPosition) == this;
    }

    public Direction getDirection() {
        BlockState state = this.level.getBlockState(this.worldPosition);
        if (state.getBlock() instanceof MarkedInjectorBlock) {
            return (Direction)state.getValue((Property)DirectionalBlock.FACING);
        }
        return Direction.UP;
    }

    public int getComparatorSignal() {
        return this.itemHandler.getStackInSlot(0).isEmpty() ? 0 : 15;
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.opStorage.load(nbt);
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        this.opStorage.save(nbt);
    }

    public void loadSync(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadSync(nbt, registries);
        this.itemHandler.load(nbt, registries);
        this.crafterPos = null;
        if (nbt.contains("crafter_pos")) {
            int[] posArray = nbt.getIntArray("crafter_pos");
            this.crafterPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
        }
    }

    public CompoundTag saveSync(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveSync(nbt, registries);
        this.itemHandler.save(nbt, registries);
        if (this.crafterPos != null) {
            nbt.putIntArray("crafter_pos", new int[]{this.crafterPos.getX(), this.crafterPos.getY(), this.crafterPos.getZ()});
        }
        return nbt;
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
        return null;
    }
}

