/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.epru.datagen;

import java.util.concurrent.CompletableFuture;
import me.jddev0.ep.recipe.CrusherRecipe;
import me.jddev0.ep.recipe.OutputItemStackWithPercentages;
import me.jddev0.ep.recipe.PlantGrowthChamberRecipe;
import me.jddev0.ep.recipe.SawmillRecipe;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;
import net.regions_unexplored.item.RuItems;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    private static final String REGIONS_UNEXPLORED_MOD_ID = "regions_unexplored";
    private static final String PATH_PREFIX = "compat/regions_unexplored/";

    public ModRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(output, lookupProvider);
    }

    protected void buildRecipes(RecipeOutput output) {
        this.buildCrusherRecipes(output);
        this.buildSawmillRecipes(output);
        this.buildPlantGrowthChamberRecipes(output);
    }

    private void buildCrusherRecipes(RecipeOutput output) {
        this.addCrusherRecipe(output, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.MOSSY_STONE.get()}), new ItemStack((ItemLike)Items.MOSSY_COBBLESTONE), "mossy_stone");
        this.addCrusherRecipe(output, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.CHALK_BRICKS.get(), (ItemLike)RuBlocks.POLISHED_CHALK.get(), (ItemLike)RuBlocks.CHALK_PILLAR.get()}), new ItemStack((ItemLike)RuBlocks.CHALK.get()), "chalk_variants");
    }

    private void buildSawmillRecipes(RecipeOutput output) {
        this.addSawmillRecipe(output, Ingredient.of((TagKey)RuTags.BRANCHES_ITEM), new ItemStack((ItemLike)Items.STICK, 6), 1, ModRecipeProvider.getItemName((ItemLike)Items.STICK), "_branches");
        this.addBasicWoodSawmillRecipe(output, new ItemStack((ItemLike)RuBlocks.BAOBAB_PLANKS.get()), Ingredient.of((TagKey)RuTags.BAOBAB_LOGS_ITEM), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BAOBAB_FENCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BAOBAB_FENCE_GATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BAOBAB_DOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BAOBAB_TRAPDOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BAOBAB_PRESSURE_PLATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BAOBAB_SIGN.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.BAOBAB_BOAT.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.BAOBAB_CHEST_BOAT.get()}), false, "baobab");
        this.addBasicWoodSawmillRecipe(output, new ItemStack((ItemLike)RuBlocks.BLACKWOOD_PLANKS.get()), Ingredient.of((TagKey)RuTags.BLACKWOOD_LOGS_ITEM), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BLACKWOOD_FENCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BLACKWOOD_FENCE_GATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BLACKWOOD_DOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BLACKWOOD_TRAPDOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BLACKWOOD_PRESSURE_PLATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BLACKWOOD_SIGN.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.BLACKWOOD_BOAT.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.BLACKWOOD_CHEST_BOAT.get()}), false, "blackwood");
        this.addBasicWoodSawmillRecipe(output, new ItemStack((ItemLike)RuBlocks.CYPRESS_PLANKS.get()), Ingredient.of((TagKey)RuTags.CYPRESS_LOGS_ITEM), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.CYPRESS_FENCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.CYPRESS_FENCE_GATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.CYPRESS_DOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.CYPRESS_TRAPDOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.CYPRESS_PRESSURE_PLATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.CYPRESS_SIGN.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.CYPRESS_BOAT.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.CYPRESS_CHEST_BOAT.get()}), false, "cypress");
        this.addBasicWoodSawmillRecipe(output, new ItemStack((ItemLike)RuBlocks.DEAD_PLANKS.get()), Ingredient.of((TagKey)RuTags.DEAD_LOGS_ITEM), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.DEAD_FENCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.DEAD_FENCE_GATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.DEAD_DOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.DEAD_TRAPDOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.DEAD_PRESSURE_PLATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.DEAD_SIGN.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.DEAD_BOAT.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.DEAD_CHEST_BOAT.get()}), false, "dead");
        this.addBasicWoodSawmillRecipe(output, new ItemStack((ItemLike)RuBlocks.EUCALYPTUS_PLANKS.get()), Ingredient.of((TagKey)RuTags.EUCALYPTUS_LOGS_ITEM), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.EUCALYPTUS_FENCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.EUCALYPTUS_FENCE_GATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.EUCALYPTUS_DOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.EUCALYPTUS_TRAPDOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.EUCALYPTUS_PRESSURE_PLATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.EUCALYPTUS_SIGN.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.EUCALYPTUS_BOAT.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.EUCALYPTUS_CHEST_BOAT.get()}), false, "eucalyptus");
        this.addBasicWoodSawmillRecipe(output, new ItemStack((ItemLike)RuBlocks.JOSHUA_PLANKS.get()), Ingredient.of((TagKey)RuTags.JOSHUA_LOGS_ITEM), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.JOSHUA_FENCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.JOSHUA_FENCE_GATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.JOSHUA_DOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.JOSHUA_TRAPDOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.JOSHUA_PRESSURE_PLATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.JOSHUA_SIGN.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.JOSHUA_BOAT.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.JOSHUA_CHEST_BOAT.get()}), false, "joshua");
        this.addBasicWoodSawmillRecipe(output, new ItemStack((ItemLike)RuBlocks.KAPOK_PLANKS.get()), Ingredient.of((TagKey)RuTags.KAPOK_LOGS_ITEM), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.KAPOK_FENCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.KAPOK_FENCE_GATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.KAPOK_DOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.KAPOK_TRAPDOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.KAPOK_PRESSURE_PLATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.KAPOK_SIGN.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.KAPOK_BOAT.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.KAPOK_CHEST_BOAT.get()}), false, "kapok");
        this.addBasicWoodSawmillRecipe(output, new ItemStack((ItemLike)RuBlocks.LARCH_PLANKS.get()), Ingredient.of((TagKey)RuTags.LARCH_LOGS_ITEM), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.LARCH_FENCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.LARCH_FENCE_GATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.LARCH_DOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.LARCH_TRAPDOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.LARCH_PRESSURE_PLATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.LARCH_SIGN.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.LARCH_BOAT.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.LARCH_CHEST_BOAT.get()}), false, "larch");
        this.addBasicWoodSawmillRecipe(output, new ItemStack((ItemLike)RuBlocks.MAGNOLIA_PLANKS.get()), Ingredient.of((TagKey)RuTags.MAGNOLIA_LOGS_ITEM), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.MAGNOLIA_FENCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.MAGNOLIA_FENCE_GATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.MAGNOLIA_DOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.MAGNOLIA_TRAPDOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.MAGNOLIA_PRESSURE_PLATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.MAGNOLIA_SIGN.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.MAGNOLIA_BOAT.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.MAGNOLIA_CHEST_BOAT.get()}), false, "magnolia");
        this.addBasicWoodSawmillRecipe(output, new ItemStack((ItemLike)RuBlocks.MAPLE_PLANKS.get()), Ingredient.of((TagKey)RuTags.MAPLE_LOGS_ITEM), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.MAPLE_FENCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.MAPLE_FENCE_GATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.MAPLE_DOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.MAPLE_TRAPDOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.MAPLE_PRESSURE_PLATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.MAPLE_SIGN.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.MAPLE_BOAT.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.MAPLE_CHEST_BOAT.get()}), false, "maple");
        this.addBasicWoodSawmillRecipe(output, new ItemStack((ItemLike)RuBlocks.MAUVE_PLANKS.get()), Ingredient.of((TagKey)RuTags.MAUVE_LOGS_ITEM), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.MAUVE_FENCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.MAUVE_FENCE_GATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.MAUVE_DOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.MAUVE_TRAPDOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.MAUVE_PRESSURE_PLATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.MAUVE_SIGN.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.MAUVE_BOAT.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.MAUVE_CHEST_BOAT.get()}), false, "mauve");
        this.addBasicWoodSawmillRecipe(output, new ItemStack((ItemLike)RuBlocks.PALM_PLANKS.get()), Ingredient.of((TagKey)RuTags.PALM_LOGS_ITEM), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.PALM_FENCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.PALM_FENCE_GATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.PALM_DOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.PALM_TRAPDOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.PALM_PRESSURE_PLATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.PALM_SIGN.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.PALM_BOAT.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.PALM_CHEST_BOAT.get()}), false, "palm");
        this.addBasicWoodSawmillRecipe(output, new ItemStack((ItemLike)RuBlocks.PINE_PLANKS.get()), Ingredient.of((TagKey)RuTags.PINE_LOGS_ITEM), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.PINE_FENCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.PINE_FENCE_GATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.PINE_DOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.PINE_TRAPDOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.PINE_PRESSURE_PLATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.PINE_SIGN.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.PINE_BOAT.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.PINE_CHEST_BOAT.get()}), false, "pine");
        this.addBasicWoodSawmillRecipe(output, new ItemStack((ItemLike)RuBlocks.REDWOOD_PLANKS.get()), Ingredient.of((TagKey)RuTags.REDWOOD_LOGS_ITEM), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.REDWOOD_FENCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.REDWOOD_FENCE_GATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.REDWOOD_DOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.REDWOOD_TRAPDOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.REDWOOD_PRESSURE_PLATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.REDWOOD_SIGN.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.REDWOOD_BOAT.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.REDWOOD_CHEST_BOAT.get()}), false, "redwood");
        this.addBasicWoodSawmillRecipe(output, new ItemStack((ItemLike)RuBlocks.SOCOTRA_PLANKS.get()), Ingredient.of((TagKey)RuTags.SOCOTRA_LOGS_ITEM), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.SOCOTRA_FENCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.SOCOTRA_FENCE_GATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.SOCOTRA_DOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.SOCOTRA_TRAPDOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.SOCOTRA_PRESSURE_PLATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.SOCOTRA_SIGN.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.SOCOTRA_BOAT.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.SOCOTRA_CHEST_BOAT.get()}), false, "socotra");
        this.addBasicWoodSawmillRecipe(output, new ItemStack((ItemLike)RuBlocks.WILLOW_PLANKS.get()), Ingredient.of((TagKey)RuTags.WILLOW_LOGS_ITEM), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.WILLOW_FENCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.WILLOW_FENCE_GATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.WILLOW_DOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.WILLOW_TRAPDOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.WILLOW_PRESSURE_PLATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.WILLOW_SIGN.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.WILLOW_BOAT.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.WILLOW_CHEST_BOAT.get()}), false, "willow");
        this.addSawmillRecipe(output, Ingredient.of((TagKey)RuTags.BLUE_BIOSHROOM_LOGS_ITEM), new ItemStack((ItemLike)RuBlocks.BLUE_BIOSHROOM_PLANKS.get(), 6), 1, "blue_bioshroom_planks", "blue_bioshroom_stems");
        this.addBasicWoodWithoutLogsAndBoatsSawmillRecipe(output, new ItemStack((ItemLike)RuBlocks.BLUE_BIOSHROOM_PLANKS.get()), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BLUE_BIOSHROOM_FENCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BLUE_BIOSHROOM_FENCE_GATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BLUE_BIOSHROOM_DOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BLUE_BIOSHROOM_TRAPDOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BLUE_BIOSHROOM_PRESSURE_PLATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BLUE_BIOSHROOM_SIGN.get()}), "blue_bioshroom");
        this.addSawmillRecipe(output, Ingredient.of((TagKey)RuTags.GREEN_BIOSHROOM_LOGS_ITEM), new ItemStack((ItemLike)RuBlocks.GREEN_BIOSHROOM_PLANKS.get(), 6), 1, "green_bioshroom_planks", "green_bioshroom_stems");
        this.addBasicWoodWithoutLogsAndBoatsSawmillRecipe(output, new ItemStack((ItemLike)RuBlocks.GREEN_BIOSHROOM_PLANKS.get()), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.GREEN_BIOSHROOM_FENCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.GREEN_BIOSHROOM_FENCE_GATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.GREEN_BIOSHROOM_DOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.GREEN_BIOSHROOM_TRAPDOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.GREEN_BIOSHROOM_PRESSURE_PLATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.GREEN_BIOSHROOM_SIGN.get()}), "green_bioshroom");
        this.addSawmillRecipe(output, Ingredient.of((TagKey)RuTags.PINK_BIOSHROOM_LOGS_ITEM), new ItemStack((ItemLike)RuBlocks.PINK_BIOSHROOM_PLANKS.get(), 6), 1, "pink_bioshroom_planks", "pink_bioshroom_stems");
        this.addBasicWoodWithoutLogsAndBoatsSawmillRecipe(output, new ItemStack((ItemLike)RuBlocks.PINK_BIOSHROOM_PLANKS.get()), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.PINK_BIOSHROOM_FENCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.PINK_BIOSHROOM_FENCE_GATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.PINK_BIOSHROOM_DOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.PINK_BIOSHROOM_TRAPDOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.PINK_BIOSHROOM_PRESSURE_PLATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.PINK_BIOSHROOM_SIGN.get()}), "pink_bioshroom");
        this.addSawmillRecipe(output, Ingredient.of((TagKey)RuTags.YELLOW_BIOSHROOM_LOGS_ITEM), new ItemStack((ItemLike)RuBlocks.YELLOW_BIOSHROOM_PLANKS.get(), 6), 1, "yellow_bioshroom_planks", "yellow_bioshroom_stems");
        this.addBasicWoodWithoutLogsAndBoatsSawmillRecipe(output, new ItemStack((ItemLike)RuBlocks.YELLOW_BIOSHROOM_PLANKS.get()), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.YELLOW_BIOSHROOM_FENCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.YELLOW_BIOSHROOM_FENCE_GATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.YELLOW_BIOSHROOM_DOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.YELLOW_BIOSHROOM_TRAPDOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.YELLOW_BIOSHROOM_PRESSURE_PLATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.YELLOW_BIOSHROOM_SIGN.get()}), "yellow_bioshroom");
        this.addSawmillRecipe(output, Ingredient.of((TagKey)RuTags.BRIMWOOD_LOGS_ITEM), new ItemStack((ItemLike)RuBlocks.BRIMWOOD_PLANKS.get(), 6), 1, "brimwood_planks", "brimwood_logs");
        this.addBasicWoodWithoutLogsAndBoatsSawmillRecipe(output, new ItemStack((ItemLike)RuBlocks.BRIMWOOD_PLANKS.get()), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BRIMWOOD_FENCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BRIMWOOD_FENCE_GATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BRIMWOOD_DOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BRIMWOOD_TRAPDOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BRIMWOOD_PRESSURE_PLATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BRIMWOOD_SIGN.get()}), "brimwood");
        this.addSawmillRecipe(output, Ingredient.of((TagKey)RuTags.COBALT_LOGS_ITEM), new ItemStack((ItemLike)RuBlocks.COBALT_PLANKS.get(), 6), 1, "cobalt_planks", "cobalt_logs");
        this.addBasicWoodWithoutLogsAndBoatsSawmillRecipe(output, new ItemStack((ItemLike)RuBlocks.COBALT_PLANKS.get()), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.COBALT_FENCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.COBALT_FENCE_GATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.COBALT_DOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.COBALT_TRAPDOOR.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.COBALT_PRESSURE_PLATE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.COBALT_SIGN.get()}), "cobalt");
        this.addSawmillRecipe(output, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.ALPHA_LOG.get()}), new ItemStack((ItemLike)RuBlocks.ALPHA_PLANKS.get()).copyWithCount(6), 1, ModRecipeProvider.getItemName((ItemLike)((ItemLike)RuBlocks.ALPHA_PLANKS.get())), "alpha_logs");
    }

    private void buildPlantGrowthChamberRecipes(RecipeOutput output) {
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.ASTER.get(), "aster");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.BLEEDING_HEART.get(), "beleeding_heart");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.DAISY.get(), "daisy");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.DORCEL.get(), "dorcel");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.FELICIA_DAISY.get(), "felicia_daisy");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.FIREWEED.get(), "fireweed");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.GLISTERING_BLOOM.get(), "glistering_bloom");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.HIBISCUS.get(), "hibiscus");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.HYSSOP.get(), "hyssop");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.MALLOW.get(), "mallow");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.POPPY_BUSH.get(), "poppy_bush");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.SALMON_POPPY_BUSH.get(), "salmon_poppy_bush");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.TSUBAKI.get(), "tsubaki");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.WARATAH.get(), "waratah");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.WHITE_TRILLIUM.get(), "white_trillium");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.WILTING_TRILLIUM.get(), "wilting_trillium");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.BLUE_LUPINE.get(), "blue_lupine");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.PINK_LUPINE.get(), "pink_lupine");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.PURPLE_LUPINE.get(), "purple_lupine");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.RED_LUPINE.get(), "red_lupine");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.YELLOW_LUPINE.get(), "yellow_lupine");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.COBALT_EARLIGHT.get(), "cobalt_earlight");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.WHITE_SNOWBELLE.get(), "white_snowbelle");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.LIGHT_GRAY_SNOWBELLE.get(), "light_gray_snowbelle");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.GRAY_SNOWBELLE.get(), "gray_snowbelle");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.RED_SNOWBELLE.get(), "red_snowbelle");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.ORANGE_SNOWBELLE.get(), "orange_snowbelle");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.YELLOW_SNOWBELLE.get(), "yellow_snowbelle");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.LIME_SNOWBELLE.get(), "lime_snowbelle");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.GREEN_SNOWBELLE.get(), "green_snowbelle");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.CYAN_SNOWBELLE.get(), "cyan_snowbelle");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.LIGHT_BLUE_SNOWBELLE.get(), "light_blue_snowbelle");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.BLUE_SNOWBELLE.get(), "blue_snowbelle");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.PURPLE_SNOWBELLE.get(), "purple_snowbelle");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.MAGENTA_SNOWBELLE.get(), "magenta_snowbelle");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.PINK_SNOWBELLE.get(), "pink_snowbelle");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.BROWN_SNOWBELLE.get(), "brown_snowbelle");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.BLACK_SNOWBELLE.get(), "black_snowbelle");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.CAVE_HYSSOP.get(), "cave_hyssop");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.ALPHA_ROSE.get(), "alpha_rose");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.ALPHA_DANDELION.get(), "alpha_dandelion");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.BARLEY.get(), "barley");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.CATTAIL.get(), "cattail");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.DAY_LILY.get(), "day_lily");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.MEADOW_SAGE.get(), "meadow_sage");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.TASSEL.get(), "tassel");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.GLISTER_BULB.get(), "glister_bulb");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.GLISTER_SPIRE.get(), "glister_spire");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.MYCOTOXIC_DAISY.get(), "mycotoxic_daisy");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)RuBlocks.TALL_COBALT_EARLIGHT.get(), "tall_cobalt_earlight");
        this.addPlantGrowthChamberRecipe(output, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.CLOVER.get()}), new OutputItemStackWithPercentages[]{new OutputItemStackWithPercentages(new ItemStack((ItemLike)RuBlocks.CLOVER.get()), new double[]{1.0, 1.0, 1.0, 0.67, 0.33, 0.33, 0.15})}, 16000, "clover", "clover");
        this.addPlantGrowthChamberRecipe(output, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.ORANGE_CONEFLOWER.get()}), new OutputItemStackWithPercentages[]{new OutputItemStackWithPercentages(new ItemStack((ItemLike)RuBlocks.ORANGE_CONEFLOWER.get()), new double[]{1.0, 1.0, 1.0, 0.67, 0.33, 0.33, 0.15})}, 16000, "orange_coneflower", "orange_coneflower");
        this.addPlantGrowthChamberRecipe(output, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.PURPLE_CONEFLOWER.get()}), new OutputItemStackWithPercentages[]{new OutputItemStackWithPercentages(new ItemStack((ItemLike)RuBlocks.PURPLE_CONEFLOWER.get()), new double[]{1.0, 1.0, 1.0, 0.67, 0.33, 0.33, 0.15})}, 16000, "purple_coneflower", "pruple_coneflower");
        this.addPlantGrowthChamberRecipe(output, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.HYACINTH_FLOWERS.get()}), new OutputItemStackWithPercentages[]{new OutputItemStackWithPercentages(new ItemStack((ItemLike)RuBlocks.HYACINTH_FLOWERS.get()), new double[]{1.0, 1.0, 1.0, 0.67, 0.33, 0.33, 0.15})}, 16000, "hyacinth_flowers", "hyacinth_flowers");
        this.addPlantGrowthChamberRecipe(output, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BLUE_MAGNOLIA_FLOWERS.get()}), new OutputItemStackWithPercentages[]{new OutputItemStackWithPercentages(new ItemStack((ItemLike)RuBlocks.BLUE_MAGNOLIA_FLOWERS.get()), new double[]{1.0, 1.0, 1.0, 0.67, 0.33, 0.33, 0.15})}, 16000, "blue_magnolia_flowers", "blue_magnolia_flowers");
        this.addPlantGrowthChamberRecipe(output, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.PINK_MAGNOLIA_FLOWERS.get()}), new OutputItemStackWithPercentages[]{new OutputItemStackWithPercentages(new ItemStack((ItemLike)RuBlocks.PINK_MAGNOLIA_FLOWERS.get()), new double[]{1.0, 1.0, 1.0, 0.67, 0.33, 0.33, 0.15})}, 16000, "pink_magnolia_flowers", "pink_magnolia_flowers");
        this.addPlantGrowthChamberRecipe(output, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.WHITE_MAGNOLIA_FLOWERS.get()}), new OutputItemStackWithPercentages[]{new OutputItemStackWithPercentages(new ItemStack((ItemLike)RuBlocks.WHITE_MAGNOLIA_FLOWERS.get()), new double[]{1.0, 1.0, 1.0, 0.67, 0.33, 0.33, 0.15})}, 16000, "white_magnolia_flowers", "white_magnolia_flowers");
        this.addPlantGrowthChamberRecipe(output, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuItems.SALMONBERRY.get()}), new OutputItemStackWithPercentages[]{new OutputItemStackWithPercentages(new ItemStack((ItemLike)RuItems.SALMONBERRY.get()), new double[]{1.0, 1.0, 0.33, 0.17})}, 16000, "salmonberry", "salmonberry");
    }

    private void addCrusherRecipe(RecipeOutput recipeOutput, Ingredient input, ItemStack output, String recipeIngredientName) {
        ResourceLocation recipeId = ResourceLocation.fromNamespaceAndPath((String)"energizedpowerru", (String)("compat/regions_unexplored/crusher/" + ModRecipeProvider.getItemName((ItemLike)output.getItem()) + "_from_crushing_" + recipeIngredientName));
        CrusherRecipe recipe = new CrusherRecipe(output, input);
        recipeOutput.accept(recipeId, (Recipe)recipe, null, new ICondition[]{this.modLoaded(REGIONS_UNEXPLORED_MOD_ID)});
    }

    private void addBasicWoodSawmillRecipe(RecipeOutput recipeOutput, ItemStack planksItem, Ingredient logsInput, Ingredient fenceInput, Ingredient fenceGateInput, Ingredient doorInput, Ingredient trapdoorInput, Ingredient pressurePlateInput, Ingredient signInput, Ingredient boatInput, Ingredient chestBoatInput, boolean isRaft, String woodName) {
        this.addSawmillRecipe(recipeOutput, logsInput, planksItem.copyWithCount(6), 1, ModRecipeProvider.getItemName((ItemLike)planksItem.getItem()), woodName + "_logs");
        this.addBasicWoodWithoutLogsSawmillRecipe(recipeOutput, planksItem, fenceInput, fenceGateInput, doorInput, trapdoorInput, pressurePlateInput, signInput, boatInput, chestBoatInput, isRaft, woodName);
    }

    private void addBasicWoodWithoutLogsSawmillRecipe(RecipeOutput recipeOutput, ItemStack planksItem, Ingredient fenceInput, Ingredient fenceGateInput, Ingredient doorInput, Ingredient trapdoorInput, Ingredient pressurePlateInput, Ingredient signInput, Ingredient boatInput, Ingredient chestBoatInput, boolean isRaft, String woodName) {
        this.addBasicWoodWithoutLogsAndBoatsSawmillRecipe(recipeOutput, planksItem, fenceInput, fenceGateInput, doorInput, trapdoorInput, pressurePlateInput, signInput, woodName);
        this.addSawmillRecipe(recipeOutput, boatInput, planksItem.copyWithCount(4), 3, ModRecipeProvider.getItemName((ItemLike)planksItem.getItem()), woodName + (isRaft ? "_raft" : "_boat"));
        this.addSawmillRecipe(recipeOutput, chestBoatInput, planksItem.copyWithCount(5), 7, ModRecipeProvider.getItemName((ItemLike)planksItem.getItem()), woodName + (isRaft ? "_chest_raft" : "_chest_boat"));
    }

    private void addBasicWoodWithoutLogsAndBoatsSawmillRecipe(RecipeOutput recipeOutput, ItemStack planksItem, Ingredient fenceInput, Ingredient fenceGateInput, Ingredient doorInput, Ingredient trapdoorInput, Ingredient pressurePlateInput, Ingredient signInput, String woodName) {
        this.addSawmillRecipe(recipeOutput, fenceInput, planksItem, 2, ModRecipeProvider.getItemName((ItemLike)planksItem.getItem()), woodName + "_fence");
        this.addSawmillRecipe(recipeOutput, fenceGateInput, planksItem.copyWithCount(2), 3, ModRecipeProvider.getItemName((ItemLike)planksItem.getItem()), woodName + "_fence_gate");
        this.addSawmillRecipe(recipeOutput, doorInput, planksItem, 3, ModRecipeProvider.getItemName((ItemLike)planksItem.getItem()), woodName + "_door");
        this.addSawmillRecipe(recipeOutput, trapdoorInput, planksItem.copyWithCount(2), 3, ModRecipeProvider.getItemName((ItemLike)planksItem.getItem()), woodName + "_trapdoor");
        this.addSawmillRecipe(recipeOutput, pressurePlateInput, planksItem, 2, ModRecipeProvider.getItemName((ItemLike)planksItem.getItem()), woodName + "_pressure_plate");
        this.addSawmillRecipe(recipeOutput, signInput, planksItem.copyWithCount(2), 1, ModRecipeProvider.getItemName((ItemLike)planksItem.getItem()), woodName + "_sign");
    }

    private void addSawmillRecipe(RecipeOutput recipeOutput, Ingredient input, ItemStack output, int sawdustAmount, String outputName, String recipeIngredientName) {
        ResourceLocation recipeId = ResourceLocation.fromNamespaceAndPath((String)"energizedpowerru", (String)("compat/regions_unexplored/sawmill/" + outputName + "_from_sawing_" + recipeIngredientName));
        SawmillRecipe recipe = new SawmillRecipe(output, input, sawdustAmount);
        recipeOutput.accept(recipeId, (Recipe)recipe, null, new ICondition[]{this.modLoaded(REGIONS_UNEXPLORED_MOD_ID)});
    }

    private void addBasicFlowerGrowingRecipe(RecipeOutput recipeOutput, ItemLike flowerItem, String outputName) {
        this.addPlantGrowthChamberRecipe(recipeOutput, Ingredient.of((ItemLike[])new ItemLike[]{flowerItem}), new OutputItemStackWithPercentages[]{new OutputItemStackWithPercentages(new ItemStack(flowerItem), new double[]{1.0, 1.0, 0.33})}, 16000, outputName, ModRecipeProvider.getItemName((ItemLike)flowerItem));
    }

    private void addPlantGrowthChamberRecipe(RecipeOutput recipeOutput, Ingredient input, OutputItemStackWithPercentages[] outputs, int ticks, String outputName, String recipeIngredientName) {
        ResourceLocation recipeId = ResourceLocation.fromNamespaceAndPath((String)"energizedpowerru", (String)("compat/regions_unexplored/growing/" + outputName + "_from_growing_" + recipeIngredientName));
        PlantGrowthChamberRecipe recipe = new PlantGrowthChamberRecipe(outputs, input, ticks);
        recipeOutput.accept(recipeId, (Recipe)recipe, null, new ICondition[]{this.modLoaded(REGIONS_UNEXPLORED_MOD_ID)});
    }
}

