/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_chicken;

import com.mojang.logging.LogUtils;
import com.oierbravo.create_mechanical_chicken.ModRegistration;
import com.oierbravo.create_mechanical_chicken.content.components.MechanicalChickenBlockEntity;
import com.oierbravo.create_mechanical_chicken.infrastructure.config.MConfigs;
import com.oierbravo.create_mechanical_chicken.infrastructure.data.ModDataGen;
import com.oierbravo.create_mechanical_chicken.ponders.ModPonderPlugin;
import com.oierbravo.create_mechanical_chicken.registrate.ModCreativeTabs;
import com.oierbravo.create_mechanical_chicken.registrate.ModFluids;
import com.oierbravo.create_mechanical_chicken.registrate.ModPartials;
import com.oierbravo.mechanicals.utility.RegistrateLangBuilder;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.tterrag.registrate.AbstractRegistrate;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.slf4j.Logger;

@Mod(value="create_mechanical_chicken")
public class CreateMechanicalChicken {
    public static final CreateRegistrate REGISTRATE = (CreateRegistrate)CreateRegistrate.create((String)"create_mechanical_chicken").defaultCreativeTab(ModCreativeTabs.MAIN_TAB.getKey());
    public static final Logger LOGGER;

    public CreateMechanicalChicken(IEventBus modEventBus, ModContainer modContainer) {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        REGISTRATE.registerEventListeners(modEventBus);
        ModCreativeTabs.register(modEventBus);
        ModRegistration.init();
        ModFluids.register();
        MConfigs.register(modLoadingContext, modContainer);
        modEventBus.addListener(this::doClientStuff);
        modEventBus.addListener(this::registerCapabilities);
        modEventBus.addListener(ModDataGen::gatherData);
        ModFluids.register();
        this.generateLangEntries();
    }

    private void generateLangEntries() {
        new RegistrateLangBuilder("create_mechanical_chicken", (AbstractRegistrate)CreateMechanicalChicken.registrate()).addCreativeTab("Create Mechanical Chicken").addJade("Mechanical chicken data").add("chicken.tooltip.progress", "Progress: %d%%").addBlockTooltipSummary("mechanical_chicken", "Chicken _Egg_ generator.").addPonderHeader("mechanical_chicken", "Generates chicken eggs").addPonderText(1, "mechanical_chicken", "The Mechanical Chicken uses rotational force and an specific fluid to generate eggs").addPonderText(2, "mechanical_chicken", "Its powered from the bottom").addPonderText(3, "mechanical_chicken", "Fluid input can ONLY go from the FRONT side").addPonderText(4, "mechanical_chicken", "Egg output is ONLY located on the BACK side").addPonderText(5, "mechanical_chicken", "Can only be extracted by automation").add("recipe", "Mechanical Chicken Recipe");
    }

    @SubscribeEvent
    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        MechanicalChickenBlockEntity.registerCapabilities(event);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        ModPartials.init();
        PonderIndex.addPlugin((PonderPlugin)new ModPonderPlugin());
    }

    public static CreateRegistrate registrate() {
        return REGISTRATE;
    }

    public static void registerLang(String id, String text) {
        CreateMechanicalChicken.registerLangCustom("create_mechanical_chicken".toLowerCase() + "." + id, text);
    }

    public static void registerLangCustom(String id, String text) {
        CreateMechanicalChicken.registrate().addRawLang(id, text);
    }

    public static TagKey<Item> commonItemTag(String path) {
        return TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)path));
    }

    public static TagKey<Fluid> commonFluidTag(String path) {
        return TagKey.create((ResourceKey)BuiltInRegistries.FLUID.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)path));
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
        LOGGER = LogUtils.getLogger();
    }
}

