/*
 * Decompiled with CFR 0.152.
 */
package com.github.bigenergy.glassential.network;

import com.github.bigenergy.glassential.blocks.entity.ColorableGlassBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ColorUpdatePacket(BlockPos pos, int color) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ColorUpdatePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"glassential", (String)"color_update"));
    public static final StreamCodec<FriendlyByteBuf, ColorUpdatePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ColorUpdatePacket::pos, (StreamCodec)StreamCodec.of((buf, value) -> buf.writeInt(value.intValue()), FriendlyByteBuf::readInt), ColorUpdatePacket::color, ColorUpdatePacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ColorUpdatePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer serverPlayer;
            BlockEntity be;
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer && (be = (serverPlayer = (ServerPlayer)patt0$temp).level().getBlockEntity(packet.pos)) instanceof ColorableGlassBlockEntity) {
                ColorableGlassBlockEntity colorable = (ColorableGlassBlockEntity)be;
                colorable.setColor(packet.color);
            }
        });
    }
}

