/*
 * Decompiled with CFR 0.152.
 */
package com.github.bigenergy.glassential.datagen;

import java.util.Map;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import org.jetbrains.annotations.NotNull;

public class GlassentialBlockLoot
extends BlockLootSubProvider {
    public GlassentialBlockLoot(HolderLookup.Provider registries) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
    }

    public void generate() {
        BuiltInRegistries.BLOCK.entrySet().stream().filter(e -> ((ResourceKey)e.getKey()).location().getNamespace().equals("glassential")).map(Map.Entry::getValue).forEach(block -> {
            if (block instanceof SlabBlock) {
                this.add((Block)block, this.createSlabItemTable((Block)block));
            } else {
                this.dropWhenSilkTouch((Block)block);
            }
        });
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        return BuiltInRegistries.BLOCK.entrySet().stream().filter(e -> ((ResourceKey)e.getKey()).location().getNamespace().equals("glassential")).map(Map.Entry::getValue).toList();
    }
}

