/*
 * Decompiled with CFR 0.152.
 */
package com.github.bigenergy.glassential.client.gui;

import com.github.bigenergy.glassential.network.GlassPainterPacket;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class GlassPainterScreen
extends Screen {
    private static final int GUI_WIDTH = 400;
    private static final int GUI_HEIGHT = 240;
    private static final int PICKER_SIZE = 180;
    private final ItemStack painterStack;
    private int selectedColor;
    private boolean emitLight;
    private boolean emitRedstone;
    private boolean passPlayer;
    private boolean passEntity;
    private int leftPos;
    private int topPos;
    private Checkbox emitLightCheckbox;
    private Checkbox emitRedstoneCheckbox;
    private Checkbox passPlayerCheckbox;
    private Checkbox passEntityCheckbox;
    private float hue = 0.0f;
    private float saturation = 1.0f;
    private float brightness = 1.0f;
    private boolean draggingPicker = false;
    private boolean draggingHue = false;
    private DynamicTexture pickerTexture;
    private ResourceLocation pickerLocation;
    private DynamicTexture hueTexture;
    private ResourceLocation hueLocation;
    private float lastHue = -1.0f;

    public GlassPainterScreen(ItemStack stack, int currentColor, boolean emitLight, boolean emitRedstone, boolean passPlayer, boolean passEntity) {
        super((Component)Component.translatable((String)"gui.glassential.glass_painter"));
        this.painterStack = stack;
        this.selectedColor = currentColor;
        this.emitLight = emitLight;
        this.emitRedstone = emitRedstone;
        this.passPlayer = passPlayer;
        this.passEntity = passEntity;
        float[] hsv = this.rgbToHsv((float)(currentColor >> 16 & 0xFF) / 255.0f, (float)(currentColor >> 8 & 0xFF) / 255.0f, (float)(currentColor & 0xFF) / 255.0f);
        this.hue = hsv[0];
        this.saturation = hsv[1];
        this.brightness = hsv[2];
    }

    protected void init() {
        super.init();
        this.leftPos = (this.width - 400) / 2;
        this.topPos = (this.height - 240) / 2;
        this.createPickerTexture();
        this.createHueTexture();
        int checkboxX = this.leftPos + 180 + 70;
        int checkboxStartY = this.topPos + 20;
        int checkboxSpacing = 22;
        this.emitLightCheckbox = Checkbox.builder((Component)Component.translatable((String)"gui.glassential.emit_light"), (Font)this.font).pos(checkboxX, checkboxStartY).selected(this.emitLight).onValueChange((checkbox, selected) -> {
            this.emitLight = selected;
        }).build();
        this.emitRedstoneCheckbox = Checkbox.builder((Component)Component.translatable((String)"gui.glassential.emit_redstone"), (Font)this.font).pos(checkboxX, checkboxStartY + checkboxSpacing).selected(this.emitRedstone).onValueChange((checkbox, selected) -> {
            this.emitRedstone = selected;
        }).build();
        this.passPlayerCheckbox = Checkbox.builder((Component)Component.translatable((String)"gui.glassential.pass_player"), (Font)this.font).pos(checkboxX, checkboxStartY + checkboxSpacing * 2).selected(this.passPlayer).onValueChange((checkbox, selected) -> {
            this.passPlayer = selected;
        }).build();
        this.passEntityCheckbox = Checkbox.builder((Component)Component.translatable((String)"gui.glassential.pass_entity"), (Font)this.font).pos(checkboxX, checkboxStartY + checkboxSpacing * 3).selected(this.passEntity).onValueChange((checkbox, selected) -> {
            this.passEntity = selected;
        }).build();
        this.addRenderableWidget((GuiEventListener)this.emitLightCheckbox);
        this.addRenderableWidget((GuiEventListener)this.emitRedstoneCheckbox);
        this.addRenderableWidget((GuiEventListener)this.passPlayerCheckbox);
        this.addRenderableWidget((GuiEventListener)this.passEntityCheckbox);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.glassential.apply"), button -> this.saveAndClose()).bounds(this.leftPos + 200 - 50, this.topPos + 240 - 30, 100, 20).build());
    }

    private void saveAndClose() {
        float[] rgb = this.hsvToRgb(this.hue, this.saturation, this.brightness);
        this.selectedColor = ((int)(rgb[0] * 255.0f) & 0xFF) << 16 | ((int)(rgb[1] * 255.0f) & 0xFF) << 8 | (int)(rgb[2] * 255.0f) & 0xFF;
        PacketDistributor.sendToServer((CustomPacketPayload)new GlassPainterPacket(this.selectedColor, this.emitLight, this.emitRedstone, this.passPlayer, this.passEntity), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.onClose();
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.fill(this.leftPos, this.topPos, this.leftPos + 400, this.topPos + 240, -535818224);
        graphics.renderOutline(this.leftPos, this.topPos, 400, 240, -7631989);
        graphics.drawString(this.font, this.title, this.leftPos + 8, this.topPos + 6, 0xFFFFFF, false);
        int pickerX = this.leftPos + 10;
        int pickerY = this.topPos + 25;
        this.drawColorPicker(graphics, pickerX, pickerY, 180, 180);
        int hueSliderX = pickerX + 180 + 10;
        int hueSliderY = pickerY;
        int hueSliderWidth = 20;
        int hueSliderHeight = 180;
        this.drawHueSlider(graphics, hueSliderX, hueSliderY, hueSliderWidth, hueSliderHeight);
        int previewX = this.leftPos + 180 + 70;
        int previewY = this.topPos + 115;
        int previewSize = 80;
        float[] rgb = this.hsvToRgb(this.hue, this.saturation, this.brightness);
        int currentColor = ((int)(rgb[0] * 255.0f) & 0xFF) << 16 | ((int)(rgb[1] * 255.0f) & 0xFF) << 8 | (int)(rgb[2] * 255.0f) & 0xFF;
        graphics.fill(previewX, previewY, previewX + previewSize, previewY + previewSize, 0xFF000000 | currentColor);
        graphics.renderOutline(previewX, previewY, previewSize, previewSize, -1);
        String hexColor = String.format("#%06X", currentColor);
        int hexX = previewX + previewSize / 2 - this.font.width(hexColor) / 2;
        graphics.drawString(this.font, hexColor, hexX, previewY + previewSize + 5, 0xFFFFFF, false);
        super.render(graphics, mouseX, mouseY, partialTick);
    }

    private void createPickerTexture() {
        if (this.pickerTexture == null) {
            NativeImage image = new NativeImage(180, 180, false);
            for (int py = 0; py < 180; ++py) {
                for (int px = 0; px < 180; ++px) {
                    float s = (float)px / 180.0f;
                    float v = 1.0f - (float)py / 180.0f;
                    float[] rgb = this.hsvToRgb(this.hue, s, v);
                    int color = 0xFF000000 | ((int)(rgb[2] * 255.0f) & 0xFF) << 16 | ((int)(rgb[1] * 255.0f) & 0xFF) << 8 | (int)(rgb[0] * 255.0f) & 0xFF;
                    image.setPixelRGBA(px, py, color);
                }
            }
            this.pickerTexture = new DynamicTexture(image);
            this.pickerLocation = this.minecraft.getTextureManager().register("glassential_picker", this.pickerTexture);
        } else if (Math.abs(this.hue - this.lastHue) > 0.001f) {
            NativeImage image = this.pickerTexture.getPixels();
            for (int py = 0; py < 180; ++py) {
                for (int px = 0; px < 180; ++px) {
                    float s = (float)px / 180.0f;
                    float v = 1.0f - (float)py / 180.0f;
                    float[] rgb = this.hsvToRgb(this.hue, s, v);
                    int color = 0xFF000000 | ((int)(rgb[2] * 255.0f) & 0xFF) << 16 | ((int)(rgb[1] * 255.0f) & 0xFF) << 8 | (int)(rgb[0] * 255.0f) & 0xFF;
                    assert (image != null);
                    image.setPixelRGBA(px, py, color);
                }
            }
            this.pickerTexture.upload();
        }
        this.lastHue = this.hue;
    }

    private void createHueTexture() {
        if (this.hueTexture == null) {
            NativeImage image = new NativeImage(20, 180, false);
            for (int py = 0; py < 180; ++py) {
                float h = (float)py / 180.0f;
                float[] rgb = this.hsvToRgb(h, 1.0f, 1.0f);
                int color = 0xFF000000 | ((int)(rgb[2] * 255.0f) & 0xFF) << 16 | ((int)(rgb[1] * 255.0f) & 0xFF) << 8 | (int)(rgb[0] * 255.0f) & 0xFF;
                for (int px = 0; px < 20; ++px) {
                    image.setPixelRGBA(px, py, color);
                }
            }
            this.hueTexture = new DynamicTexture(image);
            this.hueLocation = this.minecraft.getTextureManager().register("glassential_hue", this.hueTexture);
        }
    }

    private void drawColorPicker(GuiGraphics graphics, int x, int y, int width, int height) {
        this.createPickerTexture();
        RenderSystem.enableBlend();
        graphics.blit(this.pickerLocation, x, y, 0.0f, 0.0f, width, height, width, height);
        RenderSystem.disableBlend();
        int selX = x + (int)(this.saturation * (float)width);
        int selY = y + (int)((1.0f - this.brightness) * (float)height);
        graphics.renderOutline(selX - 4, selY - 4, 8, 8, -1);
        graphics.renderOutline(selX - 5, selY - 5, 10, 10, -16777216);
    }

    private void drawHueSlider(GuiGraphics graphics, int x, int y, int width, int height) {
        RenderSystem.enableBlend();
        graphics.blit(this.hueLocation, x, y, 0.0f, 0.0f, width, height, width, height);
        RenderSystem.disableBlend();
        graphics.renderOutline(x, y, width, height, -1);
        int selY = y + (int)(this.hue * (float)height);
        graphics.fill(x - 2, selY - 2, x + width + 2, selY + 2, -1);
        graphics.fill(x - 1, selY - 1, x + width + 1, selY + 1, -16777216);
    }

    public void removed() {
        super.removed();
        if (this.pickerTexture != null) {
            this.pickerTexture.close();
        }
        if (this.hueTexture != null) {
            this.hueTexture.close();
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int pickerX = this.leftPos + 10;
            int pickerY = this.topPos + 25;
            int hueSliderX = pickerX + 180 + 10;
            int hueSliderY = pickerY;
            int hueSliderWidth = 20;
            if (mouseX >= (double)pickerX && mouseX <= (double)(pickerX + 180) && mouseY >= (double)pickerY && mouseY <= (double)(pickerY + 180)) {
                this.draggingPicker = true;
                this.updatePickerColor(mouseX, mouseY, pickerX, pickerY);
                return true;
            }
            if (mouseX >= (double)hueSliderX && mouseX <= (double)(hueSliderX + hueSliderWidth) && mouseY >= (double)hueSliderY && mouseY <= (double)(hueSliderY + 180)) {
                this.draggingHue = true;
                this.updateHue(mouseY, hueSliderY);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.draggingPicker = false;
        this.draggingHue = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingPicker) {
            int pickerX = this.leftPos + 10;
            int pickerY = this.topPos + 25;
            this.updatePickerColor(mouseX, mouseY, pickerX, pickerY);
            return true;
        }
        if (this.draggingHue) {
            int hueSliderY = this.topPos + 25;
            this.updateHue(mouseY, hueSliderY);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    private void updatePickerColor(double mouseX, double mouseY, int pickerX, int pickerY) {
        this.saturation = Math.max(0.0f, Math.min(1.0f, (float)(mouseX - (double)pickerX) / 180.0f));
        this.brightness = Math.max(0.0f, Math.min(1.0f, 1.0f - (float)(mouseY - (double)pickerY) / 180.0f));
    }

    private void updateHue(double mouseY, int hueSliderY) {
        this.hue = Math.max(0.0f, Math.min(1.0f, (float)(mouseY - (double)hueSliderY) / 180.0f));
    }

    private float[] hsvToRgb(float h, float s, float v) {
        float[] fArray;
        int i = (int)(h * 6.0f);
        float f = h * 6.0f - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - f * s);
        float t = v * (1.0f - (1.0f - f) * s);
        switch (i % 6) {
            case 0: {
                float[] fArray2 = new float[3];
                fArray2[0] = v;
                fArray2[1] = t;
                fArray = fArray2;
                fArray2[2] = p;
                break;
            }
            case 1: {
                float[] fArray3 = new float[3];
                fArray3[0] = q;
                fArray3[1] = v;
                fArray = fArray3;
                fArray3[2] = p;
                break;
            }
            case 2: {
                float[] fArray4 = new float[3];
                fArray4[0] = p;
                fArray4[1] = v;
                fArray = fArray4;
                fArray4[2] = t;
                break;
            }
            case 3: {
                float[] fArray5 = new float[3];
                fArray5[0] = p;
                fArray5[1] = q;
                fArray = fArray5;
                fArray5[2] = v;
                break;
            }
            case 4: {
                float[] fArray6 = new float[3];
                fArray6[0] = t;
                fArray6[1] = p;
                fArray = fArray6;
                fArray6[2] = v;
                break;
            }
            case 5: {
                float[] fArray7 = new float[3];
                fArray7[0] = v;
                fArray7[1] = p;
                fArray = fArray7;
                fArray7[2] = q;
                break;
            }
            default: {
                float[] fArray8 = new float[3];
                fArray8[0] = 0.0f;
                fArray8[1] = 0.0f;
                fArray = fArray8;
                fArray8[2] = 0.0f;
            }
        }
        return fArray;
    }

    private float[] rgbToHsv(float r, float g, float b) {
        float max = Math.max(r, Math.max(g, b));
        float min = Math.min(r, Math.min(g, b));
        float delta = max - min;
        float h = 0.0f;
        if (delta != 0.0f) {
            h = max == r ? (g - b) / delta % 6.0f : (max == g ? (b - r) / delta + 2.0f : (r - g) / delta + 4.0f);
            if ((h /= 6.0f) < 0.0f) {
                h += 1.0f;
            }
        }
        float s = max == 0.0f ? 0.0f : delta / max;
        float v = max;
        return new float[]{h, s, v};
    }

    public boolean isPauseScreen() {
        return false;
    }
}

