/*
 * Decompiled with CFR 0.152.
 */
package com.github.bigenergy.glassential.client.gui;

import com.github.bigenergy.glassential.network.ColorUpdatePacket;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class ColorPickerScreen
extends Screen {
    private final BlockPos blockPos;
    private int selectedColor = 0xFFFFFF;
    private static final int PICKER_SIZE = 256;
    private static final int HUE_BAR_WIDTH = 20;
    private static final int PADDING = 10;
    private int pickerX;
    private int pickerY;
    private int hueBarX;
    private float hue = 0.0f;
    private float saturation = 1.0f;
    private float brightness = 1.0f;

    public ColorPickerScreen(BlockPos blockPos, int currentColor) {
        super((Component)Component.literal((String)"Color Picker"));
        this.blockPos = blockPos;
        this.selectedColor = currentColor;
        int r = currentColor >> 16 & 0xFF;
        int g = currentColor >> 8 & 0xFF;
        int b = currentColor & 0xFF;
        float[] hsb = ColorPickerScreen.rgbToHsb(r, g, b);
        this.hue = hsb[0];
        this.saturation = hsb[1];
        this.brightness = hsb[2];
    }

    protected void init() {
        super.init();
        int totalWidth = 286;
        this.pickerX = (this.width - totalWidth) / 2;
        this.pickerY = (this.height - 256) / 2;
        this.hueBarX = this.pickerX + 256 + 10;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.renderColorPicker(guiGraphics);
        this.renderHueBar(guiGraphics);
        this.renderColorInfo(guiGraphics);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderColorPicker(GuiGraphics guiGraphics) {
        Matrix4f matrix = guiGraphics.pose().last().pose();
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        int step = 4;
        for (int y = 0; y < 256; y += step) {
            for (int x = 0; x < 256; x += step) {
                float s = (float)x / 256.0f;
                float b = 1.0f - (float)y / 256.0f;
                int color = ColorPickerScreen.hsbToRgb(this.hue, s, b);
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int bl = color & 0xFF;
                float x1 = this.pickerX + x;
                float y1 = this.pickerY + y;
                float x2 = x1 + (float)step;
                float y2 = y1 + (float)step;
                bufferBuilder.addVertex(matrix, x1, y2, 0.0f).setColor(r, g, bl, 255);
                bufferBuilder.addVertex(matrix, x2, y2, 0.0f).setColor(r, g, bl, 255);
                bufferBuilder.addVertex(matrix, x2, y1, 0.0f).setColor(r, g, bl, 255);
                bufferBuilder.addVertex(matrix, x1, y1, 0.0f).setColor(r, g, bl, 255);
            }
        }
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.disableBlend();
        int indicatorX = this.pickerX + (int)(this.saturation * 256.0f);
        int indicatorY = this.pickerY + (int)((1.0f - this.brightness) * 256.0f);
        guiGraphics.fill(indicatorX - 3, indicatorY - 3, indicatorX + 3, indicatorY + 3, -1);
        guiGraphics.fill(indicatorX - 2, indicatorY - 2, indicatorX + 2, indicatorY + 2, -16777216);
    }

    private void renderHueBar(GuiGraphics guiGraphics) {
        Matrix4f matrix = guiGraphics.pose().last().pose();
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        int step = 2;
        for (int y = 0; y < 256; y += step) {
            float h = (float)y / 256.0f;
            int color = ColorPickerScreen.hsbToRgb(h, 1.0f, 1.0f);
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int bl = color & 0xFF;
            float y1 = this.pickerY + y;
            float y2 = y1 + (float)step;
            bufferBuilder.addVertex(matrix, (float)this.hueBarX, y2, 0.0f).setColor(r, g, bl, 255);
            bufferBuilder.addVertex(matrix, (float)(this.hueBarX + 20), y2, 0.0f).setColor(r, g, bl, 255);
            bufferBuilder.addVertex(matrix, (float)(this.hueBarX + 20), y1, 0.0f).setColor(r, g, bl, 255);
            bufferBuilder.addVertex(matrix, (float)this.hueBarX, y1, 0.0f).setColor(r, g, bl, 255);
        }
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.disableBlend();
        int indicatorY = this.pickerY + (int)(this.hue * 256.0f);
        guiGraphics.fill(this.hueBarX - 2, indicatorY - 2, this.hueBarX + 20 + 2, indicatorY + 2, -1);
    }

    private void renderColorInfo(GuiGraphics guiGraphics) {
        int previewSize = 40;
        int previewX = this.pickerX;
        int previewY = this.pickerY + 256 + 10;
        guiGraphics.fill(previewX, previewY, previewX + previewSize, previewY + previewSize, 0xFF000000 | this.selectedColor);
        String hexValue = String.format("#%06X", this.selectedColor);
        guiGraphics.drawString(this.font, hexValue, previewX + previewSize + 10, previewY + 15, -1);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (mouseX >= (double)this.pickerX && mouseX < (double)(this.pickerX + 256) && mouseY >= (double)this.pickerY && mouseY < (double)(this.pickerY + 256)) {
                this.updateColorFromPicker((int)mouseX, (int)mouseY);
                return true;
            }
            if (mouseX >= (double)this.hueBarX && mouseX < (double)(this.hueBarX + 20) && mouseY >= (double)this.pickerY && mouseY < (double)(this.pickerY + 256)) {
                this.updateHue((int)mouseY);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0) {
            if (mouseX >= (double)this.pickerX && mouseX < (double)(this.pickerX + 256) && mouseY >= (double)this.pickerY && mouseY < (double)(this.pickerY + 256)) {
                this.updateColorFromPicker((int)mouseX, (int)mouseY);
                return true;
            }
            if (mouseX >= (double)this.hueBarX && mouseX < (double)(this.hueBarX + 20) && mouseY >= (double)this.pickerY && mouseY < (double)(this.pickerY + 256)) {
                this.updateHue((int)mouseY);
                return true;
            }
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    private void updateColorFromPicker(int mouseX, int mouseY) {
        this.saturation = Math.max(0.0f, Math.min(1.0f, (float)(mouseX - this.pickerX) / 256.0f));
        this.brightness = Math.max(0.0f, Math.min(1.0f, 1.0f - (float)(mouseY - this.pickerY) / 256.0f));
        this.selectedColor = ColorPickerScreen.hsbToRgb(this.hue, this.saturation, this.brightness);
    }

    private void updateHue(int mouseY) {
        this.hue = Math.max(0.0f, Math.min(1.0f, (float)(mouseY - this.pickerY) / 256.0f));
        this.selectedColor = ColorPickerScreen.hsbToRgb(this.hue, this.saturation, this.brightness);
    }

    public void onClose() {
        PacketDistributor.sendToServer((CustomPacketPayload)new ColorUpdatePacket(this.blockPos, this.selectedColor), (CustomPacketPayload[])new CustomPacketPayload[0]);
        super.onClose();
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.fill(0, 0, this.width, this.height, Integer.MIN_VALUE);
    }

    private static int hsbToRgb(float hue, float saturation, float brightness) {
        int rgb = Color.HSBtoRGB(hue, saturation, brightness);
        return rgb & 0xFFFFFF;
    }

    private static float[] rgbToHsb(int r, int g, int b) {
        return Color.RGBtoHSB(r, g, b, null);
    }
}

