/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.data;

import alabaster.crabbersdelight.CrabbersDelight;
import alabaster.crabbersdelight.common.registry.CDModBlocks;
import alabaster.crabbersdelight.common.registry.CDModItems;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ItemModels
extends ItemModelProvider {
    public static final String GENERATED = "item/generated";
    public static final String HANDHELD = "item/handheld";

    public ItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "crabbersdelight", existingFileHelper);
    }

    protected void registerModels() {
        Set<Item> items = BuiltInRegistries.ITEM.stream().filter(i -> "crabbersdelight".equals(BuiltInRegistries.ITEM.getKey(i).getNamespace())).collect(Collectors.toSet());
        items.remove(CDModItems.CRAB_CLAW.get());
        items.remove(CDModItems.COCONUT_HELMET.get());
        items.remove(CDModItems.CRAB_SPAWN_EGG.get());
        this.blockBasedModel(CDModItems.SEA_PICKLE_CRATE.get(), "_bottom");
        items.remove(CDModItems.SEA_PICKLE_CRATE.get());
        this.buttonItem(CDModItems.PALM_BUTTON.get(), CDModBlocks.PALM_PLANKS.get());
        this.fenceItem(CDModItems.PALM_FENCE.get(), CDModBlocks.PALM_PLANKS.get());
        items.remove(CDModItems.PALM_FENCE.get());
        items.remove(CDModItems.PALM_BUTTON.get());
        HashSet spriteBlockItems = Sets.newHashSet((Object[])new Item[]{CDModItems.PALM_DOOR.get(), CDModItems.PALM_SIGN.get(), CDModItems.PALM_HANGING_SIGN.get(), CDModItems.COCONUT.get(), CDModItems.SEASHELLS.get()});
        ItemModels.takeAll(items, spriteBlockItems.toArray(new Item[0])).forEach(item -> ((ItemModelBuilder)this.withExistingParent(this.itemName((Item)item), GENERATED)).texture("layer0", this.resourceItem(this.itemName((Item)item))));
        HashSet flatBlockItems = Sets.newHashSet((Object[])new Item[]{CDModItems.PALM_SAPLING.get()});
        ItemModels.takeAll(items, flatBlockItems.toArray(new Item[0])).forEach(item -> this.itemGeneratedModel((Item)item, this.resourceBlock(this.itemName((Item)item))));
        ItemModels.takeAll(items, i -> i instanceof BlockItem).forEach(item -> this.blockBasedModel((Item)item, ""));
        HashSet handheldItems = Sets.newHashSet();
        ItemModels.takeAll(items, handheldItems.toArray(new Item[0])).forEach(item -> this.itemHandheldModel((Item)item, this.resourceItem(this.itemName((Item)item))));
        items.forEach(item -> this.itemGeneratedModel((Item)item, this.resourceItem(this.itemName((Item)item))));
    }

    public void blockBasedModel(Item item, String suffix) {
        this.withExistingParent(this.itemName(item), this.resourceBlock(this.itemName(item) + suffix));
    }

    public void buttonItem(Item buttonItem, Block baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(buttonItem), this.mcLoc("block/button_inventory"))).texture("texture", this.resourceBlock(this.itemName(baseBlock.asItem())));
    }

    public void fenceItem(Item fenceItem, Block baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(fenceItem), this.mcLoc("block/fence_inventory"))).texture("texture", this.resourceBlock(this.itemName(baseBlock.asItem())));
    }

    public void itemHandheldModel(Item item, ResourceLocation texture) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), HANDHELD)).texture("layer0", texture);
    }

    public void itemGeneratedModel(Item item, ResourceLocation texture) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), GENERATED)).texture("layer0", texture);
    }

    private String itemName(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).getPath();
    }

    public ResourceLocation resourceBlock(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)("block/" + path));
    }

    public ResourceLocation resourceItem(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)("item/" + path));
    }

    @SafeVarargs
    public static <T> Collection<T> takeAll(Set<? extends T> src, T ... items) {
        List<T> ret = Arrays.asList(items);
        for (T item : items) {
            if (src.contains(item)) continue;
            CrabbersDelight.LOGGER.warn("Item {} not found in set", item);
        }
        if (!src.removeAll(ret)) {
            CrabbersDelight.LOGGER.warn("takeAll array didn't yield anything ({})", (Object)Arrays.toString(items));
        }
        return ret;
    }

    public static <T> Collection<T> takeAll(Set<T> src, Predicate<T> pred) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterator<T> iter = src.iterator();
        while (iter.hasNext()) {
            T item = iter.next();
            if (!pred.test(item)) continue;
            iter.remove();
            ret.add(item);
        }
        if (ret.isEmpty()) {
            CrabbersDelight.LOGGER.warn("takeAll predicate yielded nothing", new Throwable());
        }
        return ret;
    }
}

