/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.worldgen;

import alabaster.crabbersdelight.common.Config;
import alabaster.crabbersdelight.common.block.SeashellBlock;
import alabaster.crabbersdelight.common.registry.CDModBlocks;
import alabaster.crabbersdelight.common.utils.CDStateProviders;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;

public class RandomSeashellStateProvider
extends BlockStateProvider {
    private final boolean waterlogged;
    public static final MapCodec<RandomSeashellStateProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("waterlogged", (Object)false).forGetter(p -> p.waterlogged)).apply((Applicative)instance, RandomSeashellStateProvider::new));

    public RandomSeashellStateProvider(boolean waterlogged) {
        this.waterlogged = waterlogged;
    }

    protected BlockStateProviderType<?> type() {
        return CDStateProviders.RANDOM_SEASHELL.get();
    }

    public BlockState getState(RandomSource random, BlockPos pos) {
        int variant = random.nextInt(((Integer)Config.SEASHELL_VARIANT_COUNT.get()).intValue());
        Direction facing = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        return (BlockState)((BlockState)((BlockState)CDModBlocks.SEASHELLS.get().defaultBlockState().setValue((Property)SeashellBlock.VARIANT, (Comparable)Integer.valueOf(variant))).setValue((Property)SeashellBlock.FACING, (Comparable)facing)).setValue((Property)SeashellBlock.WATERLOGGED, (Comparable)Boolean.valueOf(this.waterlogged));
    }
}

