/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.event;

import alabaster.crabbersdelight.common.Config;
import alabaster.crabbersdelight.common.registry.CDModItems;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.BasicItemListing;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.event.village.WandererTradesEvent;

@EventBusSubscriber(modid="crabbersdelight")
@ParametersAreNonnullByDefault
public class VillagerTrade {
    @SubscribeEvent
    public static void onVillagerTrades(VillagerTradesEvent event) {
        if (!((Boolean)Config.FISHERMAN_BUY_SEAFOOD.get()).booleanValue()) {
            return;
        }
        Int2ObjectMap trades = event.getTrades();
        VillagerProfession profession = event.getType();
        ResourceLocation professionKey = BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)profession);
        if (professionKey == null) {
            return;
        }
        if (professionKey.getPath().equals("fisherman")) {
            ((List)trades.get(1)).add(VillagerTrade.emeraldForItemsTrade((ItemLike)CDModItems.RAW_CRAB.get(), 6, 16, 2));
            ((List)trades.get(1)).add(VillagerTrade.emeraldForItemsTrade((ItemLike)CDModItems.RAW_SHRIMP.get(), 8, 16, 2));
            ((List)trades.get(2)).add(VillagerTrade.emeraldForItemsTrade((ItemLike)CDModItems.RAW_CLAWSTER.get(), 4, 16, 5));
            ((List)trades.get(2)).add(VillagerTrade.emeraldForItemsTrade((ItemLike)CDModItems.CLAM.get(), 3, 16, 5));
            ((List)trades.get(4)).add(VillagerTrade.emeraldForItemsTrade((ItemLike)CDModItems.PEARL.get(), 1, 16, 5));
        }
    }

    @SubscribeEvent
    public static void onWandererTrades(WandererTradesEvent event) {
        if (((Boolean)Config.WANDERING_TRADER_PEARLS.get()).booleanValue()) {
            List trades = event.getGenericTrades();
            trades.add(VillagerTrade.emeraldForItemsTrade((ItemLike)CDModItems.CRAB_CLAW.get(), 8, 4, 12));
            trades.add(VillagerTrade.heartForPearlsTrade((ItemLike)CDModItems.PEARL.get(), 32, 4, 12));
            trades.add(VillagerTrade.spongeForPearlsTrade((ItemLike)CDModItems.PEARL.get(), 8, 4, 12));
            trades.add(VillagerTrade.tridentForPearlsTrade((ItemLike)CDModItems.PEARL.get(), 64, 1, 12));
        }
    }

    public static BasicItemListing emeraldForItemsTrade(ItemLike item, int count, int maxTrades, int xp) {
        return new BasicItemListing(new ItemStack(item, count), new ItemStack((ItemLike)Items.EMERALD), maxTrades, xp, 0.05f);
    }

    public static BasicItemListing heartForPearlsTrade(ItemLike item, int count, int maxTrades, int xp) {
        return new BasicItemListing(new ItemStack(item, count), new ItemStack((ItemLike)Items.HEART_OF_THE_SEA), maxTrades, xp, 0.05f);
    }

    public static BasicItemListing spongeForPearlsTrade(ItemLike item, int count, int maxTrades, int xp) {
        return new BasicItemListing(new ItemStack(item, count), new ItemStack((ItemLike)Items.SPONGE), maxTrades, xp, 0.05f);
    }

    public static BasicItemListing tridentForPearlsTrade(ItemLike item, int count, int maxTrades, int xp) {
        return new BasicItemListing(new ItemStack(item, count), new ItemStack((ItemLike)Items.TRIDENT), maxTrades, xp, 0.05f);
    }
}

