/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.block;

import alabaster.crabbersdelight.common.registry.CDModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class CDLeavesBlock
extends LeavesBlock {
    public static final BooleanProperty GENERATED = BooleanProperty.create((String)"generated");

    public CDLeavesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)GENERATED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{GENERATED});
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        boolean connected;
        if (!((Boolean)state.getValue((Property)GENERATED)).booleanValue() && !((Boolean)state.getValue((Property)PERSISTENT)).booleanValue()) {
            super.randomTick(state, level, pos, random);
            return;
        }
        if (((Boolean)state.getValue((Property)GENERATED)).booleanValue() && !(connected = this.hasPalmLogNearby((Level)level, pos, 4))) {
            level.destroyBlock(pos, true);
        }
    }

    private boolean hasPalmLogNearby(Level level, BlockPos pos, int range) {
        for (int dx = -range; dx <= range; ++dx) {
            for (int dy = -range; dy <= range; ++dy) {
                for (int dz = -range; dz <= range; ++dz) {
                    BlockPos checkPos;
                    BlockState state;
                    if (dx == 0 && dy == 0 && dz == 0 || !(state = level.getBlockState(checkPos = pos.offset(dx, dy, dz))).is(CDModBlocks.PALM_LOG.get())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)PERSISTENT) == false || (Boolean)state.getValue((Property)GENERATED) != false;
    }
}

