/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight;

import alabaster.crabbersdelight.client.gui.CrabTrapGUI;
import alabaster.crabbersdelight.common.Config;
import alabaster.crabbersdelight.common.entity.boat.CDBoatModelLayers;
import alabaster.crabbersdelight.common.entity.boat.CDBoatRenderer;
import alabaster.crabbersdelight.common.entity.crab.CrabEntity;
import alabaster.crabbersdelight.common.entity.crab.CrabModel;
import alabaster.crabbersdelight.common.entity.crab.CrabRenderer;
import alabaster.crabbersdelight.common.event.CDSpriteSourceProvider;
import alabaster.crabbersdelight.common.registry.CDFoliagePlacerTypes;
import alabaster.crabbersdelight.common.registry.CDModBlockEntity;
import alabaster.crabbersdelight.common.registry.CDModBlocks;
import alabaster.crabbersdelight.common.registry.CDModCreativeTabs;
import alabaster.crabbersdelight.common.registry.CDModEntities;
import alabaster.crabbersdelight.common.registry.CDModItems;
import alabaster.crabbersdelight.common.registry.CDModMenus;
import alabaster.crabbersdelight.common.registry.CDModPotions;
import alabaster.crabbersdelight.common.registry.CDTrunkPlacerTypes;
import alabaster.crabbersdelight.common.utils.CDStateProviders;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="crabbersdelight")
public class CrabbersDelight {
    public static final String MODID = "crabbersdelight";
    public static final Logger LOGGER = LogManager.getLogger();

    public CrabbersDelight(IEventBus bus, ModContainer modContainer) {
        if (FMLEnvironment.dist.isClient()) {
            bus.addListener(this::registerScreens);
        }
        bus.addListener(this::gatherData);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_CONFIG);
        CDModItems.ITEMS.register(bus);
        CDModBlocks.BLOCKS.register(bus);
        CDModBlockEntity.BLOCK_ENTITY_TYPES.register(bus);
        CDModMenus.MENU.register(bus);
        CDModCreativeTabs.CREATIVE_TAB.register(bus);
        CDModPotions.POTIONS.register(bus);
        CDModEntities.ENTITY_TYPES.register(bus);
        CDTrunkPlacerTypes.TRUNK_PLACERS.register(bus);
        CDFoliagePlacerTypes.FOLIAGE_PLACERS.register(bus);
        CDStateProviders.PROVIDERS.register(bus);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    public static ResourceLocation modPrefix(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public void gatherData(GatherDataEvent event) {
        boolean includeClient = event.includeClient();
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(includeClient, (DataProvider)new CDSpriteSourceProvider(packOutput, lookupProvider, fileHelper));
    }

    public void registerScreens(RegisterMenuScreensEvent event) {
        event.register(CDModMenus.CRAB_TRAP_MENU.get(), CrabTrapGUI::new);
    }

    @EventBusSubscriber(modid="crabbersdelight", bus=EventBusSubscriber.Bus.MOD)
    public class ModEventBusEvents {
        public ModEventBusEvents(CrabbersDelight this$0) {
        }

        @SubscribeEvent
        public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(CrabModel.LAYER_LOCATION, CrabModel::createBodyLayer);
            event.registerLayerDefinition(CDBoatModelLayers.PALM_BOAT_LAYER, BoatModel::createBodyModel);
            event.registerLayerDefinition(CDBoatModelLayers.PALM_CHEST_BOAT_LAYER, ChestBoatModel::createBodyModel);
        }

        @SubscribeEvent
        public static void registerAttributes(EntityAttributeCreationEvent event) {
            event.put(CDModEntities.CRAB.get(), CrabEntity.createAttributes().build());
        }
    }

    @EventBusSubscriber(modid="crabbersdelight", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.register(CDModEntities.CRAB.get(), CrabRenderer::new);
            EntityRenderers.register(CDModEntities.MOD_BOAT.get(), pContext -> new CDBoatRenderer(pContext, false));
            EntityRenderers.register(CDModEntities.MOD_CHEST_BOAT.get(), pContext -> new CDBoatRenderer(pContext, true));
        }

        @SubscribeEvent
        public static void registerSpawnPlacements(RegisterSpawnPlacementsEvent event) {
            event.register(CDModEntities.CRAB.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CrabEntity::checkCrabSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        }

        @SubscribeEvent
        public static void registerBER(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer(CDModBlockEntity.PALM_SIGN.get(), SignRenderer::new);
            event.registerBlockEntityRenderer(CDModBlockEntity.HANGING_PALM_SIGN.get(), HangingSignRenderer::new);
        }
    }
}

