/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.Helpers;

public class ItemPromiseAcceptor
extends Item {
    private final Type type;

    public ItemPromiseAcceptor(Item.Properties properties, Type type) {
        super(properties);
        this.type = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFoil(ItemStack itemStack) {
        return true;
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        IRON("iron", Helpers.RGBAToInt((int)255, (int)255, (int)255, (int)255)),
        GOLD("gold", Helpers.RGBAToInt((int)230, (int)230, (int)160, (int)255)),
        DIAMOND("diamond", Helpers.RGBAToInt((int)150, (int)250, (int)200, (int)255));

        private final String name;
        private final int color;

        private Type(String name, int color) {
            this.name = name;
            this.color = color;
        }

        public String getName() {
            return this.name;
        }

        public int getColor() {
            return this.color;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ItemColor
    implements net.minecraft.client.color.item.ItemColor {
        public int getColor(ItemStack itemStack, int renderPass) {
            return ((ItemPromiseAcceptor)itemStack.getItem()).getType().getColor();
        }
    }
}

