/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.component.DataComponentBiomeConfig;
import org.cyclops.evilcraft.entity.item.EntityBiomeExtract;
import org.cyclops.evilcraft.item.ItemBiomeExtractConfig;

public class ItemBiomeExtract
extends Item {
    public ItemBiomeExtract(Item.Properties properties) {
        super(properties);
    }

    public static HolderLookup.RegistryLookup<Biome> getBiomeRegistry(HolderLookup.Provider holders) {
        return holders.lookupOrThrow(Registries.BIOME);
    }

    public String getDescriptionId(ItemStack itemStack) {
        return super.getDescriptionId(itemStack) + (ItemBiomeExtract.getBiome(itemStack) == null ? ".empty" : "");
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!world.isClientSide() && ItemBiomeExtract.getBiome(itemStack) != null && !ItemBiomeExtractConfig.isUsageBlacklisted(ItemBiomeExtract.getBiome(itemStack))) {
            world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 0.5f, 0.4f / (world.random.nextFloat() * 0.4f + 0.8f));
            EntityBiomeExtract entity = new EntityBiomeExtract(world, (LivingEntity)player, itemStack.copy());
            entity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), -20.0f, 0.5f, 1.0f);
            world.addFreshEntity((Entity)entity);
            if (!player.isCreative()) {
                itemStack.shrink(1);
            }
        }
        return MinecraftHelpers.successAction((Object)itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemStack, context, list, flag);
        Holder<Biome> biome = ItemBiomeExtract.getBiome(itemStack);
        if (biome != null) {
            ResourceLocation key = ((ResourceKey)biome.unwrapKey().get()).location();
            list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".info.content"), (Object[])new Object[]{Component.translatable((String)("biome." + key.getNamespace() + "." + key.getPath()))}));
        }
    }

    public Stream<Holder.Reference<Biome>> getBiomes(HolderLookup.Provider holders) {
        return ItemBiomeExtract.getBiomeRegistry(holders).listElements();
    }

    public boolean isEmpty(ItemStack itemStack) {
        return ItemBiomeExtract.getBiome(itemStack) == null;
    }

    @Nullable
    public static Holder<Biome> getBiome(ItemStack itemStack) {
        DataComponentBiomeConfig.BiomeHolder holder = (DataComponentBiomeConfig.BiomeHolder)itemStack.get(RegistryEntries.COMPONENT_BIOME);
        return holder != null ? holder.getBiome() : null;
    }

    public ItemStack createItemStack(Holder<Biome> biome, int amount, HolderGetter<Biome> holderGetter) {
        ItemStack itemStack = new ItemStack((ItemLike)this, amount);
        if (biome != null) {
            itemStack.set(RegistryEntries.COMPONENT_BIOME, (Object)new DataComponentBiomeConfig.BiomeHolder(((ResourceKey)biome.unwrapKey().get()).location(), holderGetter));
            itemStack.set(DataComponents.RARITY, (Object)this.getRarity(biome));
        }
        return itemStack;
    }

    protected Rarity getRarity(Holder<Biome> biome) {
        return ((Biome)biome.value()).getMobSettings().getCreatureProbability() <= 0.05f ? Rarity.EPIC : (((Biome)biome.value()).getMobSettings().getCreatureProbability() <= 0.1f ? Rarity.RARE : Rarity.UNCOMMON);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ItemColor
    implements net.minecraft.client.color.item.ItemColor {
        public int getColor(ItemStack itemStack, int renderPass) {
            if (renderPass == 0) {
                ItemBiomeExtract cfr_ignored_0 = (ItemBiomeExtract)((Object)RegistryEntries.ITEM_BIOME_EXTRACT.get());
                Holder<Biome> biome = ItemBiomeExtract.getBiome(itemStack);
                if (biome != null) {
                    Triple rgb = Helpers.intToRGB((int)((Biome)biome.value()).getFoliageColor());
                    return Helpers.RGBAToInt((int)((int)(((Float)rgb.getLeft()).floatValue() * 255.0f)), (int)((int)(((Float)rgb.getMiddle()).floatValue() * 255.0f)), (int)((int)(((Float)rgb.getRight()).floatValue() * 255.0f)), (int)255);
                }
                return Helpers.RGBAToInt((int)125, (int)125, (int)125, (int)255);
            }
            return -1;
        }
    }
}

