/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.infobook;

import com.google.common.collect.Maps;
import java.util.HashMap;
import net.minecraft.world.item.crafting.RecipeType;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoBook;
import org.cyclops.cyclopscore.infobook.InfoBookParser;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendix;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.api.broom.BroomModifier;
import org.cyclops.evilcraft.api.broom.BroomModifiers;
import org.cyclops.evilcraft.infobook.pageelement.BloodInfuserRecipeAppendix;
import org.cyclops.evilcraft.infobook.pageelement.BroomModifierRecipeAppendix;
import org.cyclops.evilcraft.infobook.pageelement.EnvironmentalAccumulatorRecipeAppendix;
import org.w3c.dom.Element;

public class OriginsOfDarknessBook
extends InfoBook {
    private static OriginsOfDarknessBook _instance = null;

    private OriginsOfDarknessBook() {
        super((ModBase)EvilCraft._instance, 2, "https://evilcraft.rubensworks.net/book/");
    }

    public static synchronized OriginsOfDarknessBook getInstance() {
        if (_instance == null) {
            _instance = new OriginsOfDarknessBook();
        }
        return _instance;
    }

    static {
        InfoBookParser.registerAppendixRecipeFactories((RecipeType)((RecipeType)RegistryEntries.RECIPETYPE_BLOOD_INFUSER.get()), BloodInfuserRecipeAppendix::new);
        InfoBookParser.registerAppendixRecipeFactories((RecipeType)((RecipeType)RegistryEntries.RECIPETYPE_ENVIRONMENTAL_ACCUMULATOR.get()), EnvironmentalAccumulatorRecipeAppendix::new);
        InfoBookParser.registerAppendixFactory((String)"evilcraft:broom_modifier", (InfoBookParser.IAppendixFactory)new InfoBookParser.IAppendixFactory(){

            public SectionAppendix create(IInfoBook infoBook, Element node) throws InfoBookParser.InvalidAppendixException {
                String id = node.getTextContent();
                HashMap values = Maps.newHashMap();
                BroomModifier finalModifier = null;
                for (BroomModifier modifier : BroomModifiers.REGISTRY.getModifiers()) {
                    if (!modifier.getId().toString().equals(id)) continue;
                    finalModifier = modifier;
                    values.putAll(BroomModifiers.REGISTRY.getItemsFromModifier(modifier));
                }
                if (finalModifier == null) {
                    throw new InfoBookParser.InvalidAppendixException("Could not find the broom modifier " + id);
                }
                if (values.isEmpty()) {
                    throw new InfoBookParser.InvalidAppendixException("The broom modifier " + id + " has no valid items");
                }
                return new BroomModifierRecipeAppendix(infoBook, finalModifier, values);
            }
        });
    }
}

