/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.inventory.slot;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.cyclops.evilcraft.core.blockentity.BlockEntityWorking;
import org.cyclops.evilcraft.core.inventory.container.ContainerTileWorking;

public class SlotWorking<T extends BlockEntityWorking<T, ?>>
extends Slot {
    protected ContainerTileWorking<T> container;
    private ItemStack lastSlotContents = null;
    private final Level world;

    public SlotWorking(int index, int x, int y, ContainerTileWorking<T> container, Level world) {
        super(container.getContainerInventory(), index, x, y);
        this.container = container;
        this.lastSlotContents = this.getItem();
        this.world = world;
    }

    public boolean mayPlace(ItemStack itemStack) {
        return !itemStack.isEmpty() && this.container.getTileWorkingMetadata().canConsume(itemStack, this.world);
    }

    public void onTake(Player player, ItemStack itemStack) {
        this.container.getTileSupplier().ifPresent(tile -> {
            if (!ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)this.getItem())) {
                tile.resetWork();
            }
        });
        super.onTake(player, itemStack);
    }

    public void setChanged() {
        this.container.getTileSupplier().ifPresent(tile -> {
            if (!ItemStack.isSameItemSameComponents((ItemStack)this.lastSlotContents, (ItemStack)this.getItem())) {
                tile.resetWork();
            }
        });
        this.lastSlotContents = this.getItem();
        if (!this.lastSlotContents.isEmpty()) {
            this.lastSlotContents = this.lastSlotContents.copy();
        }
    }
}

