/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity.tickaction.purifier;

import com.google.common.collect.Lists;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.cyclops.evilcraft.api.tileentity.purifier.IPurifierAction;
import org.cyclops.evilcraft.block.BlockPurifierConfig;
import org.cyclops.evilcraft.blockentity.BlockEntityPurifier;
import org.cyclops.evilcraft.core.algorithm.Wrapper;

public class DisenchantPurifyAction
implements IPurifierAction {
    public static final Wrapper<Item> ALLOWED_BOOK = new Wrapper();
    private static final int PURIFY_DURATION = 60;

    protected boolean isAllowed(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return false;
        }
        for (String name : BlockPurifierConfig.disenchantBlacklist) {
            if (!BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).toString().matches(name)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isItemValidForMainSlot(ItemStack itemStack) {
        return this.isAllowed(itemStack);
    }

    @Override
    public boolean isItemValidForAdditionalSlot(ItemStack itemStack) {
        return !itemStack.isEmpty() && itemStack.getItem() == ALLOWED_BOOK.get();
    }

    @Override
    public boolean canWork(BlockEntityPurifier tile) {
        if (tile.getBucketsFloored() == tile.getMaxBuckets() && !tile.getPurifyItem().isEmpty() && !tile.getAdditionalItem().isEmpty() && tile.getAdditionalItem().getItem() == ALLOWED_BOOK.get()) {
            return this.isAllowed(tile.getPurifyItem()) && tile.getPurifyItem().get(DataComponents.ENCHANTMENTS) != null;
        }
        return false;
    }

    @Override
    public boolean work(BlockEntityPurifier tile) {
        boolean done = false;
        ItemStack purifyItem = tile.getPurifyItem().copy();
        Level world = tile.getLevel();
        int tick = tile.getTick();
        ItemEnchantments enchantments = (ItemEnchantments)purifyItem.get(DataComponents.ENCHANTMENTS);
        if (enchantments != null && !enchantments.isEmpty()) {
            if (tick >= 60) {
                if (!world.isClientSide()) {
                    Holder<Enchantment> enchantment = this.getRandomEnchantment(world, enchantments);
                    this.setResultingEnchantmentBook(tile, enchantments, enchantment);
                    this.removePriorWorkPenalty(enchantments, purifyItem);
                    purifyItem = this.setRemainingEnchantmentsOnPurifiedItem(enchantments, enchantment, purifyItem);
                    tile.setPurifyItem(purifyItem);
                }
                tile.setBuckets(0, tile.getBucketsRest());
                done = true;
            }
            if (world.isClientSide()) {
                tile.showEffect();
                tile.showEnchantingEffect();
            }
        }
        return done;
    }

    private Holder<Enchantment> getRandomEnchantment(Level world, ItemEnchantments enchantments) {
        int enchantmentIndex = world.random.nextInt(enchantments.size());
        return (Holder)Lists.newArrayList((Iterable)enchantments.keySet()).get(enchantmentIndex);
    }

    private void setResultingEnchantmentBook(BlockEntityPurifier tile, ItemEnchantments enchantments, Holder<Enchantment> enchantment) {
        tile.setAdditionalItem(EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(enchantment, enchantments.getLevel(enchantment))));
    }

    private void removePriorWorkPenalty(ItemEnchantments enchantments, ItemStack purifyItem) {
        int penalty = (Integer)purifyItem.getOrDefault(DataComponents.REPAIR_COST, (Object)0);
        int remainingPenalty = penalty - penalty / enchantments.size();
        purifyItem.set(DataComponents.REPAIR_COST, (Object)remainingPenalty);
    }

    private ItemStack setRemainingEnchantmentsOnPurifiedItem(ItemEnchantments enchantments, Holder<Enchantment> enchantment, ItemStack purifyItem) {
        ItemEnchantments.Mutable enchantmentsMutable = new ItemEnchantments.Mutable(enchantments);
        enchantmentsMutable.set(enchantment, 0);
        if (enchantmentsMutable.keySet().isEmpty() && purifyItem.getItem() == Items.ENCHANTED_BOOK) {
            purifyItem = new ItemStack((ItemLike)Items.BOOK);
        }
        EnchantmentHelper.setEnchantments((ItemStack)purifyItem, (ItemEnchantments)enchantmentsMutable.toImmutable());
        return purifyItem;
    }
}

