/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.cyclops.cyclopscore.capability.item.ItemHandlerSlotMasked;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.slot.SlotFluidContainer;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockBoxOfEternalClosure;
import org.cyclops.evilcraft.block.BlockSpiritReanimator;
import org.cyclops.evilcraft.blockentity.tickaction.EmptyFluidContainerInTankTickAction;
import org.cyclops.evilcraft.blockentity.tickaction.spiritreanimator.ReanimateTickAction;
import org.cyclops.evilcraft.core.blockentity.BlockEntityWorking;
import org.cyclops.evilcraft.core.blockentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.blockentity.tickaction.TickComponent;
import org.cyclops.evilcraft.core.blockentity.upgrade.IUpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.blockentity.upgrade.UpgradeBehaviour;
import org.cyclops.evilcraft.core.blockentity.upgrade.Upgrades;
import org.cyclops.evilcraft.core.fluid.BloodFluidConverter;
import org.cyclops.evilcraft.core.fluid.ImplicitFluidConversionTank;
import org.cyclops.evilcraft.inventory.container.ContainerSpiritReanimator;

public class BlockEntitySpiritReanimator
extends BlockEntityWorking<BlockEntitySpiritReanimator, MutableDouble>
implements MenuProvider {
    public static final int SLOT_CONTAINER = 0;
    public static final int SLOT_BOX = 1;
    public static final int SLOT_EGG = 2;
    public static final int SLOTS_OUTPUT = 3;
    public static final int SLOTS = 4;
    public static Metadata METADATA = new Metadata();
    public static final int LIQUID_PER_SLOT = 10000;
    private static final Map<Class<?>, ITickAction<BlockEntitySpiritReanimator>> REANIMATE_COOK_TICK_ACTIONS = new LinkedHashMap();
    private static final Map<Class<?>, ITickAction<BlockEntitySpiritReanimator>> EMPTY_IN_TANK_TICK_ACTIONS;
    public static int TICKERS;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_SPEED;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_BLOODUSAGE;
    private int reanimateTicker = this.addTicker(new TickComponent<BlockEntitySpiritReanimator, ITickAction<BlockEntitySpiritReanimator>>(this, REANIMATE_COOK_TICK_ACTIONS, 1, true, false));
    @NBTPersist
    private Boolean caughtError = false;

    public BlockEntitySpiritReanimator(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_SPIRIT_REANIMATOR.get(), blockPos, blockState, 4, 64, 10000, (Fluid)RegistryEntries.FLUID_BLOOD.get());
        this.addTicker(new TickComponent<BlockEntitySpiritReanimator, ITickAction<BlockEntitySpiritReanimator>>(this, EMPTY_IN_TANK_TICK_ACTIONS, 0, false, true));
        this.upgradeBehaviour.put(Upgrades.UPGRADE_SPEED, new UpgradeBehaviour<BlockEntitySpiritReanimator, MutableDouble>(this, 1.0){

            @Override
            public void applyUpgrade(BlockEntitySpiritReanimator upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableDouble> event) {
                double val;
                if (event.getType() == UPGRADEEVENT_SPEED) {
                    val = event.getObject().getValue();
                    event.getObject().setValue(val /= 1.0 + (double)upgradeLevel / this.valueFactor);
                }
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    val = event.getObject().getValue();
                    event.getObject().setValue(val *= 1.0 + (double)upgradeLevel / this.valueFactor);
                }
            }
        });
        this.upgradeBehaviour.put(Upgrades.UPGRADE_EFFICIENCY, new UpgradeBehaviour<BlockEntitySpiritReanimator, MutableDouble>(this, 2.0){

            @Override
            public void applyUpgrade(BlockEntitySpiritReanimator upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableDouble> event) {
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    double val = event.getObject().getValue();
                    event.getObject().setValue(val /= 1.0 + (double)upgradeLevel / this.valueFactor);
                }
            }
        });
    }

    @Override
    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new BlockEntityWorking.Inventory<BlockEntitySpiritReanimator>(inventorySize, stackSize, this){

            @Override
            public boolean canPlaceItem(int slot, ItemStack itemStack) {
                if (slot == 1) {
                    return BlockEntitySpiritReanimator.this.getTileWorkingMetadata().canConsume(itemStack, BlockEntitySpiritReanimator.this.getLevel());
                }
                if (slot == 2) {
                    return itemStack.getItem() == Items.EGG;
                }
                if (slot == 0) {
                    return SlotFluidContainer.checkIsItemValid((ItemStack)itemStack, (Fluid)((Fluid)RegistryEntries.FLUID_BLOOD.get()));
                }
                return super.canPlaceItem(slot, itemStack);
            }
        };
    }

    public Direction getRotation() {
        return ((Direction)BlockHelpers.getSafeBlockStateProperty((BlockState)this.getLevel().getBlockState(this.getBlockPos()), (Property)BlockSpiritReanimator.FACING, (Comparable)Direction.NORTH)).getOpposite();
    }

    @Override
    protected SingleUseTank createTank(int tankSize) {
        return new ImplicitFluidConversionTank(tankSize, BloodFluidConverter.getInstance());
    }

    @Override
    protected int getWorkTicker() {
        return this.reanimateTicker;
    }

    @Nullable
    public EntityType<?> getEntityType() {
        ItemStack boxStack = this.getInventory().getItem(this.getConsumeSlot());
        if (boxStack.getItem() == BlockEntitySpiritReanimator.getAllowedCookItem()) {
            return BlockBoxOfEternalClosure.getSpiritTypeRaw(boxStack);
        }
        return null;
    }

    public static Item getAllowedCookItem() {
        return (Item)RegistryEntries.ITEM_BOX_OF_ETERNAL_CLOSURE.get();
    }

    public int getConsumeSlot() {
        return 1;
    }

    @Override
    public Metadata getTileWorkingMetadata() {
        return METADATA;
    }

    @Override
    public boolean canWork() {
        ItemStack eggStack = this.getInventory().getItem(2);
        ItemStack outputStack = this.getInventory().getItem(3);
        EntityType<?> entityType = this.getEntityType();
        boolean validNameStack = entityType != null && (outputStack.isEmpty() || outputStack.getMaxStackSize() > outputStack.getCount() && SpawnEggItem.byId(entityType) == outputStack.getItem());
        return !eggStack.isEmpty() && validNameStack;
    }

    @Override
    public void onStateChanged() {
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.level.getBlockState(this.getBlockPos()).setValue((Property)BlockSpiritReanimator.ON, (Comparable)Boolean.valueOf(this.isWorking())));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerSpiritReanimator(id, playerInventory, (Container)this.getInventory(), Optional.of(this));
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.evilcraft.spirit_reanimator");
    }

    static {
        REANIMATE_COOK_TICK_ACTIONS.put(BlockBoxOfEternalClosure.class, new ReanimateTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS = new LinkedHashMap();
        EMPTY_IN_TANK_TICK_ACTIONS.put(Item.class, new EmptyFluidContainerInTankTickAction());
        TICKERS = 2;
        UPGRADEEVENT_SPEED = Upgrades.newUpgradeEventType();
        UPGRADEEVENT_BLOODUSAGE = Upgrades.newUpgradeEventType();
    }

    private static class Metadata
    extends BlockEntityWorking.Metadata {
        private Metadata() {
            super(4);
        }

        @Override
        public boolean canConsume(ItemStack itemStack, Level world) {
            return !itemStack.isEmpty() && BlockEntitySpiritReanimator.getAllowedCookItem() == itemStack.getItem();
        }

        @Override
        protected Block getBlock() {
            return (Block)RegistryEntries.BLOCK_SPIRIT_REANIMATOR.get();
        }
    }

    public static class CapabilityRegistrar
    extends BlockEntityWorking.CapabilityRegistrar<BlockEntitySpiritReanimator, MutableDouble> {
        public CapabilityRegistrar(Supplier<BlockEntityType<? extends BlockEntitySpiritReanimator>> blockEntityType) {
            super(blockEntityType);
        }

        @Override
        public void registerTankInventoryCapabilitiesItem() {
            this.add(Capabilities.ItemHandler.BLOCK, (blockEntity, direction) -> {
                int[] slots = direction == Direction.UP ? new int[]{2} : (direction == Direction.DOWN ? new int[]{3} : new int[]{0, 1});
                return new ItemHandlerSlotMasked((Container)blockEntity.getInventory(), slots);
            });
        }
    }
}

